/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_ja_api.api.facade;

import com.lhia.client.api.lhia_ja_api.api.dto.AnalysisResponseDTO;
import com.lhia.client.api.lhia_ja_api.api.dto.FileType;
import com.lhia.client.api.lhia_ja_api.api.dto.ServiceDocumentDTO;
import com.lhia.client.api.lhia_ja_api.api.dto.ValidateRequestDTO;
import com.lhia.client.api.lhia_ja_api.api.mapper.FormValidationMapper;
import com.lhia.client.api.lhia_ja_api.api.mapper.JsonResponseMapper;
import com.lhia.client.api.lhia_ja_api.api.mapper.ServiceDocumentMapper;
import com.lhia.client.api.lhia_ja_api.client.apis.OpenAiClient;
import com.lhia.client.api.lhia_ja_api.client.models.OperationResult;
import com.lhia.client.api.lhia_ja_api.common.exceptions.DuplicateReferenceFormException;
import com.lhia.client.api.lhia_ja_api.common.exceptions.PdfConversionException;
import com.lhia.client.api.lhia_ja_api.common.exceptions.ValidationException;
import com.lhia.client.api.lhia_ja_api.common.helper.ConversationHelper;
import com.lhia.client.api.lhia_ja_api.common.helper.PdfToImageConverter;
import com.lhia.client.api.lhia_ja_api.common.util.ImageConverterUtil;
import com.lhia.client.api.lhia_ja_api.common.util.LhiaPromptsUtil;
import com.lhia.client.api.lhia_ja_api.common.util.PathUtil;
import com.lhia.client.api.lhia_ja_api.config.ApiResponse;
import com.lhia.client.api.lhia_ja_api.config.AppProperties;
import com.lhia.client.api.lhia_ja_api.infrastructure.entity.TAnalysisEntity;
import com.lhia.client.api.lhia_ja_api.infrastructure.entity.TFormValidationEntity;
import com.lhia.client.api.lhia_ja_api.infrastructure.service.AnalysisService;
import com.lhia.client.api.lhia_ja_api.infrastructure.service.FormValidationService;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.UUID;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ValidationFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationFacade.class);
    private final FormValidationService formValidationService;
    private final AnalysisService analysisService;
    private final OpenAiClient openAiClient;
    private final AppProperties props;

    public ValidationFacade(FormValidationService formValidationService, AnalysisService analysisService, OpenAiClient openAiClient, AppProperties props) {
        this.formValidationService = formValidationService;
        this.analysisService = analysisService;
        this.openAiClient = openAiClient;
        this.props = props;
    }

    public ResponseEntity<ApiResponse<AnalysisResponseDTO>> getByReferenceForm(String referenceForm) {
        TAnalysisEntity analysisFind = this.analysisService.getByReferenceForm(referenceForm);
        AnalysisResponseDTO analysisDTO = FormValidationMapper.getAnalyzedAddressDTO((String)referenceForm, (TAnalysisEntity)analysisFind);
        return ResponseEntity.ok((Object)ApiResponse.ok((String)"An\u00e1lisis Encontrado", (Object)analysisDTO));
    }

    public ResponseEntity<ApiResponse<AnalysisResponseDTO>> validate(ValidateRequestDTO request) {
        byte[] imageFileV3 = request.fileType() == FileType.PDF ? (byte[])PdfToImageConverter.convertFirstPageFromBase64Pdf((String)request.fileBase64()).orElseThrow(() -> new PdfConversionException("Error en el archivo PDF: no pudo ser convertido")) : ImageConverterUtil.decodeAndValidateImage((String)request.fileBase64());
        log.info("Tama\u00f1o de imagen generado: {} bytes", (Object)imageFileV3.length);
        log.info("Iniciando validaci\u00f3n para referenciaForm={} de tipo={}", (Object)request.referenceForm(), (Object)request.fileType());
        byte[] imageFile = this.compressBase64ToDataUri(imageFileV3, 0.5f, 0.7f);
        try {
            TFormValidationEntity formValidationNew = FormValidationMapper.getFormValidationNew((ValidateRequestDTO)request, (byte[])imageFile);
            log.info("Guardando entidad FormValidationPartner={}\u2026", (Object)formValidationNew.getPartnerIdNumber());
            TFormValidationEntity formValidationSaved = this.formValidationService.save(formValidationNew);
            log.info("FormValidation guardado con ID={} y archivo ID={}", (Object)formValidationSaved.getId(), (Object)formValidationSaved.getFileContent().getId());
            String urlImage = PathUtil.generateFileContentUrl((UUID)formValidationSaved.getFileContent().getId(), (String)this.props.getBaseUrl(), (String)this.props.getBasePath(), (String)this.props.getFileAssetsPath());
            String promptDocument = LhiaPromptsUtil.promptDocument((String)request.formAddress());
            log.info("Enviando prompt a LHIA (imagen={}, promptLength={})", (Object)urlImage, (Object)promptDocument.length());
            Map conversationData = ConversationHelper.getConversationData((String)urlImage, (String)promptDocument);
            OperationResult result = this.openAiClient.sendMessage(conversationData);
            log.info("Data Result: {}", (Object)result.getContent());
            ServiceDocumentDTO doc = (ServiceDocumentDTO)JsonResponseMapper.parseJson((String)result.getContent(), ServiceDocumentDTO.class).orElseThrow(() -> new IllegalArgumentException("JSON inv\u00e1lido o faltan campos obligatorios"));
            log.debug("DTO parseado: {}", (Object)doc);
            TAnalysisEntity analysisNew = ServiceDocumentMapper.toEntity((ServiceDocumentDTO)doc);
            analysisNew.setFormValidation(formValidationSaved);
            log.info("Guardando an\u00e1lisis para FormValidationID={}", (Object)formValidationSaved.getId());
            TAnalysisEntity analysisSave = this.analysisService.save(analysisNew);
            log.info("An\u00e1lisis guardado con \u00e9xito (AnalysisID={})", (Object)analysisSave.getId());
            AnalysisResponseDTO analysisDTO = FormValidationMapper.getAnalyzedAddressDTO((String)formValidationSaved.getReferenceForm(), (TAnalysisEntity)analysisSave);
            return ResponseEntity.ok((Object)ApiResponse.ok((String)"An\u00e1lisis completado", (Object)analysisDTO));
        }
        catch (DataIntegrityViolationException ex) {
            String rootMsg = ex.getMostSpecificCause().getMessage();
            if (rootMsg != null && rootMsg.contains("t_form_validation_reference_form_key")) {
                throw new DuplicateReferenceFormException(request.referenceForm(), "No se pudo guardar el an\u00e1lisis: la referencia '" + request.referenceForm() + "' ya existe en el sistema.");
            }
            throw ex;
        }
        catch (Exception ex) {
            log.error("Error durante la validaci\u00f3n para referenceForm={}: {}", new Object[]{request.referenceForm(), ex.getMessage(), ex});
            throw new ValidationException("Error interno durante la validaci\u00f3n", (Throwable)ex);
        }
    }

    public byte[] compressBase64ToDataUri(byte[] imageBytes, float scaleFactor, float quality) {
        try {
            BufferedImage original = ImageIO.read(new ByteArrayInputStream(imageBytes));
            if (original == null) {
                return imageBytes;
            }
            int newWidth = Math.round((float)original.getWidth() * scaleFactor);
            int newHeight = Math.round((float)original.getHeight() * scaleFactor);
            Image tmp = original.getScaledInstance(newWidth, newHeight, 4);
            BufferedImage resized = new BufferedImage(newWidth, newHeight, 1);
            Graphics2D g2d = resized.createGraphics();
            g2d.drawImage(tmp, 0, 0, null);
            g2d.dispose();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(os);
            writer.setOutput(ios);
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(quality);
            writer.write(null, new IIOImage(resized, null, null), param);
            writer.dispose();
            ios.close();
            return os.toByteArray();
        }
        catch (Exception e) {
            return imageBytes;
        }
    }
}

