/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_ja_api.api.dto;

import com.lhia.client.api.lhia_ja_api.api.dto.FileType;
import com.lhia.client.api.lhia_ja_api.api.dto.PartnerDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;

@Schema(name="ValidateRequestDTO", description="Solicitud de validaci\u00f3n de comprobante seg\u00fan especificaci\u00f3n ja v1.0")
public record ValidateRequestDTO(@Valid @NotNull @Schema(description="Datos del socio que realiza la solicitud") PartnerDTO partner, @NotBlank @Size(min=5, max=500) @Schema(description="Direcci\u00f3n declarada en el formulario (sin normalizar)", example="Av. 12 de Octubre y Av. Loja, Cuenca") @NotBlank @Size(min=5, max=500) String formAddress, @NotBlank @Size(min=3, max=64) @Schema(description="Referencia del formulario previo (apertura de cuenta o cr\u00e9dito)", example="RF-2025-000123") @NotBlank @Size(min=3, max=64) String referenceForm, @NotNull @Schema(description="Tipo de archivo cargado", example="PNG", allowableValues={"PDF", "JPG", "JPG", "PNG"}) FileType fileType, @NotBlank @Schema(description="Archivo del comprobante codificado en Base64 (PDF 1 p\u00e1gina, JPG o PNG)", example="JVBERi0xLjQKJeLjz9MKMyAwIG9iago8PAov...") String fileBase64) {
    @Valid
    @NotNull
    @Schema(description="Datos del socio que realiza la solicitud")
    private final PartnerDTO partner;
    @NotBlank
    @Size(min=5, max=500)
    @Schema(description="Direcci\u00f3n declarada en el formulario (sin normalizar)", example="Av. 12 de Octubre y Av. Loja, Cuenca")
    private final @NotBlank @Size(min=5, max=500) String formAddress;
    @NotBlank
    @Size(min=3, max=64)
    @Schema(description="Referencia del formulario previo (apertura de cuenta o cr\u00e9dito)", example="RF-2025-000123")
    private final @NotBlank @Size(min=3, max=64) String referenceForm;
    @NotNull
    @Schema(description="Tipo de archivo cargado", example="PNG", allowableValues={"PDF", "JPG", "JPG", "PNG"})
    private final FileType fileType;
    @NotBlank
    @Schema(description="Archivo del comprobante codificado en Base64 (PDF 1 p\u00e1gina, JPG o PNG)", example="JVBERi0xLjQKJeLjz9MKMyAwIG9iago8PAov...")
    private final String fileBase64;

    public ValidateRequestDTO(@Valid @NotNull @Schema(description="Datos del socio que realiza la solicitud") PartnerDTO partner, @NotBlank @Size(min=5, max=500) @Schema(description="Direcci\u00f3n declarada en el formulario (sin normalizar)", example="Av. 12 de Octubre y Av. Loja, Cuenca") @NotBlank @Size(min=5, max=500) String formAddress, @NotBlank @Size(min=3, max=64) @Schema(description="Referencia del formulario previo (apertura de cuenta o cr\u00e9dito)", example="RF-2025-000123") @NotBlank @Size(min=3, max=64) String referenceForm, @NotNull @Schema(description="Tipo de archivo cargado", example="PNG", allowableValues={"PDF", "JPG", "JPG", "PNG"}) FileType fileType, @NotBlank @Schema(description="Archivo del comprobante codificado en Base64 (PDF 1 p\u00e1gina, JPG o PNG)", example="JVBERi0xLjQKJeLjz9MKMyAwIG9iago8PAov...") String fileBase64) {
        this.partner = partner;
        this.formAddress = formAddress;
        this.referenceForm = referenceForm;
        this.fileType = fileType;
        this.fileBase64 = fileBase64;
    }

    @Valid
    @NotNull
    @Schema(description="Datos del socio que realiza la solicitud")
    public PartnerDTO partner() {
        return this.partner;
    }

    @NotBlank
    @Size(min=5, max=500)
    @Schema(description="Direcci\u00f3n declarada en el formulario (sin normalizar)", example="Av. 12 de Octubre y Av. Loja, Cuenca")
    public @NotBlank @Size(min=5, max=500) String formAddress() {
        return this.formAddress;
    }

    @NotBlank
    @Size(min=3, max=64)
    @Schema(description="Referencia del formulario previo (apertura de cuenta o cr\u00e9dito)", example="RF-2025-000123")
    public @NotBlank @Size(min=3, max=64) String referenceForm() {
        return this.referenceForm;
    }

    @NotNull
    @Schema(description="Tipo de archivo cargado", example="PNG", allowableValues={"PDF", "JPG", "JPG", "PNG"})
    public FileType fileType() {
        return this.fileType;
    }

    @NotBlank
    @Schema(description="Archivo del comprobante codificado en Base64 (PDF 1 p\u00e1gina, JPG o PNG)", example="JVBERi0xLjQKJeLjz9MKMyAwIG9iago8PAov...")
    public String fileBase64() {
        return this.fileBase64;
    }
}

