/*
 * Decompiled with CFR 0.152.
 */
package com.lhia.client.api.lhia_ja_api.api.controller;

import com.lhia.client.api.lhia_ja_api.api.dto.AnalysisResponseDTO;
import com.lhia.client.api.lhia_ja_api.api.dto.ValidateRequestDTO;
import com.lhia.client.api.lhia_ja_api.api.facade.ValidationFacade;
import com.lhia.client.api.lhia_ja_api.config.ApiResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Validations", description="Validaci\u00f3n de Planilla (ja v1.0)")
@RestController
@RequestMapping(value={"/validations"})
public class ValidationController {
    private final ValidationFacade validationFacade;

    @Operation(summary="Validar Planilla PDF o imagen", description="Recibe una planilla en Base64 y devuelve el resultado del an\u00e1lisis.")
    @PostMapping(value={"/validate"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<ApiResponse<AnalysisResponseDTO>> validate(@io.swagger.v3.oas.annotations.parameters.RequestBody(description="Payload con Base64 del archivo y metadatos necesarios para la validaci\u00f3n", required=true, content={@Content(schema=@Schema(implementation=ValidateRequestDTO.class))}) @Valid @RequestBody ValidateRequestDTO request) {
        return this.validationFacade.validate(request);
    }

    @Operation(summary="Obtener an\u00e1lisis por referencia", description="Devuelve el an\u00e1lisis ya realizado para la referencia proporcionada.")
    @GetMapping(value={"/{referenceForm}"}, produces={"application/json"})
    public ResponseEntity<ApiResponse<AnalysisResponseDTO>> findById(@Parameter(description="Referencia \u00fanica del formulario a consultar", example="RF-2025-00012", required=true) @PathVariable(value="referenceForm") String referenceForm) {
        return this.validationFacade.getByReferenceForm(referenceForm);
    }

    @Generated
    public ValidationController(ValidationFacade validationFacade) {
        this.validationFacade = validationFacade;
    }
}

