/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.utils;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.reportes.exceptions.CustomException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static boolean isValidBase64(String base64String) {
        if (base64String == null || base64String.isEmpty()) {
            return false;
        }
        try {
            Base64.getDecoder().decode(base64String);
            return true;
        }
        catch (IllegalArgumentException e) {
            log.warn("not a valid base64");
            return false;
        }
    }

    public static Boolean isPdfFile(String base64String) {
        byte[] data = Base64.getDecoder().decode(base64String);
        String headerStr = new String(data, 0, 5);
        return headerStr.equals("%PDF-");
    }

    public static int getPageNumber(byte[] pdfContent) {
        try {
            PdfReader reader = new PdfReader((InputStream)new ByteArrayInputStream(pdfContent));
            PdfDocument document = new PdfDocument(reader);
            int numberOfPages = document.getNumberOfPages();
            document.close();
            reader.close();
            return numberOfPages;
        }
        catch (Exception e) {
            throw new CustomException("No se ha podido identificar la p\u00e1gina a firmar", HttpStatus.BAD_REQUEST);
        }
    }
}

