/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.service.impl;

import com.reportes.exceptions.CustomException;
import com.reportes.logic.entity.vistas.ReporteBiometria29;
import com.reportes.logic.repository.ReporteBiometriaDAO;
import com.reportes.logic.service.ReporteService;
import com.reportes.utils.Utils;
import ec.tws2.crypto.run.CryptoMain;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ReporteServiceImpl
implements ReporteService {
    private static final Logger log = LoggerFactory.getLogger(ReporteServiceImpl.class);
    private final ReporteBiometriaDAO reporteBiometriaDAO;
    private final CryptoMain cryptoService;
    private final Environment env;

    public String generateBase64PdfReport(String codigo) throws Exception, CustomException {
        String rutaReportes = this.env.getProperty("path.reports");
        ReporteBiometria29 reporte = this.reporteBiometriaDAO.findLatestByCodigo(codigo);
        if (reporte == null) {
            throw new CustomException("No se encontr\u00f3 el reporte con el c\u00f3digo solicitado", HttpStatus.NOT_FOUND);
        }
        ClassPathResource resource = new ClassPathResource("reports/reporte.jasper");
        FileInputStream reportStream = new FileInputStream(rutaReportes + "reporte.jasper");
        String img_selfie = reporte.getImgSelfie();
        String img_front = this.cryptoService.decrypt(reporte.getImgFrontal());
        String img_back = this.cryptoService.decrypt(reporte.getImgReverso());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("meta", this.cryptoService.decrypt(reporte.getMetadata()));
        parameters.put("fecha_nacimiento", reporte.getFechaNacimiento());
        parameters.put("identificador", this.cryptoService.decrypt(reporte.getIdentificacion()));
        parameters.put("codigo_dactilar", this.cryptoService.decrypt(reporte.getCodigoDactilar()));
        parameters.put("estado_civil", reporte.getEstadoCivil());
        parameters.put("fecha_expedicion", reporte.getFechaEmision());
        parameters.put("nacionalidad", reporte.getNacionalidad());
        parameters.put("uuid", reporte.getCodigo());
        parameters.put("coincidencia_rostro", reporte.getRostroSimilitud().toString());
        parameters.put("coincidencia_rostro_frontal", reporte.getRostroSimilitudFrontal().toString());
        parameters.put("coincidencia_selfie", reporte.getRostroSimilitudSelfie().toString());
        parameters.put("numero_intentos", reporte.getIntentos());
        parameters.put("firma_documento", reporte.getType());
        parameters.put("fecha_hora_firma", reporte.getSign_date() == null ? "" : reporte.getSign_date());
        parameters.put("img_front", Utils.isValidBase64((String)img_front) ? img_front : null);
        parameters.put("img_back", Utils.isValidBase64((String)img_back) ? img_back : null);
        parameters.put("img_selfie", Utils.isValidBase64((String)img_selfie) ? img_selfie : null);
        parameters.put("nombre_completo", this.cryptoService.decrypt(reporte.getNombre_completo()));
        parameters.put("lugar_nacimiento", this.cryptoService.decrypt(reporte.getLugar_nacimiento()));
        JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)reportStream, parameters, (JRDataSource)new JREmptyDataSource());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
        byte[] pdfBytes = outputStream.toByteArray();
        return Base64.getEncoder().encodeToString(pdfBytes);
    }

    public ReporteServiceImpl(ReporteBiometriaDAO reporteBiometriaDAO, CryptoMain cryptoService, Environment env) {
        this.reporteBiometriaDAO = reporteBiometriaDAO;
        this.cryptoService = cryptoService;
        this.env = env;
    }
}

