/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.service.impl;

import com.reportes.logic.data.ViewInformacionProcessDTO;
import com.reportes.logic.entity.vistas.ViewInformationProcess;
import com.reportes.logic.repository.CallbackBiometriaDAO;
import com.reportes.logic.repository.CallbackFirmaDAO;
import com.reportes.logic.repository.SolicitudDAO;
import com.reportes.logic.repository.ViewInformationProcessDAO;
import com.reportes.logic.service.DataReportTws;
import com.reportes.utils.ApiResponse;
import ec.tws2.crypto.run.CryptoMain;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DataReportTwsImpl
implements DataReportTws {
    private static final Logger log = LoggerFactory.getLogger(DataReportTwsImpl.class);
    private final SolicitudDAO solicitudDAO;
    private final CallbackBiometriaDAO callbackBiometriaDAO;
    private final CallbackFirmaDAO callbackFirmaDAO;
    private final ViewInformationProcessDAO viewInformationProcessDAO;
    private final CryptoMain cryptoService;

    public ResponseEntity<ApiResponse<?>> getStatusResponseByDate(LocalDateTime start, LocalDateTime end) {
        List listSolicitude;
        ApiResponse apiResponse = ApiResponse.ok((Object)listSolicitude, (!(listSolicitude = this.solicitudDAO.getSolicitudStatusResponses(start, end)).isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> getBiometricStatics(LocalDateTime start, LocalDateTime end) {
        List listSolicitude;
        ApiResponse apiResponse = ApiResponse.ok((Object)listSolicitude, (!(listSolicitude = this.solicitudDAO.getBiometricStatics(start, end)).isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> getTimeLineBiometricsPerDay(LocalDateTime start, LocalDateTime end) {
        List listSolicitude;
        ApiResponse apiResponse = ApiResponse.ok((Object)listSolicitude, (!(listSolicitude = this.callbackBiometriaDAO.getTimeLineBiometricByDay(start, end)).isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> getSignedDocsStatus(LocalDateTime start, LocalDateTime end, int page, int size) {
        Page listSolicitude;
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        ApiResponse apiResponse = ApiResponse.ok((Object)listSolicitude, (!(listSolicitude = this.callbackFirmaDAO.getSignedDocsStatus(start, end, (Pageable)pageable)).isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> getSignStatics(LocalDateTime start, LocalDateTime end) {
        List listSolicitude;
        ApiResponse apiResponse = ApiResponse.ok((Object)listSolicitude, (!(listSolicitude = this.callbackFirmaDAO.getSignStatics(start, end)).isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> getTimeLineSignByDay(LocalDateTime start, LocalDateTime end) {
        List listSolicitude;
        ApiResponse apiResponse = ApiResponse.ok((Object)listSolicitude, (!(listSolicitude = this.callbackFirmaDAO.getTimeLineSignByDay(start, end)).isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> getRouteOfProcessByCode(String code, int page, int size) {
        Page listSolicitude;
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        ApiResponse apiResponse = ApiResponse.ok((Object)listSolicitude, (!(listSolicitude = this.viewInformationProcessDAO.getRouteOfProcessByCode(code, (Pageable)pageable)).isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> getRouteOfProcessByDate(LocalDateTime start, LocalDateTime end, int page, int size, String channel, Optional<String> identificacion) {
        Page listSolicitudes;
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        log.info("filtrando con parametros: start: {}, end: {}, channel: {}", new Object[]{start, end, channel});
        if (identificacion.isPresent() && !identificacion.get().isEmpty()) {
            log.info("filtrando con identificacion: {}", (Object)this.cryptoService.encriptar(identificacion.get()));
            listSolicitudes = this.viewInformationProcessDAO.findByIdentification(this.cryptoService.encriptar(identificacion.get()), (Pageable)pageable);
        } else if (channel == null || ((String)channel).equalsIgnoreCase("todo") || ((String)channel).equalsIgnoreCase("undefined") || ((String)channel).equalsIgnoreCase("")) {
            listSolicitudes = this.viewInformationProcessDAO.getRouteOfProcessByDate(start, end, (Pageable)pageable);
        } else {
            channel = ";" + (String)channel + ";";
            listSolicitudes = this.viewInformationProcessDAO.getRouteOfProcessByDateAndLike(start, end, (String)channel, (Pageable)pageable);
        }
        List listProcessDTO = this.processViewExtractDataDto(listSolicitudes.getContent());
        PageImpl newContent = new PageImpl(listProcessDTO, listSolicitudes.getPageable(), listSolicitudes.getTotalElements());
        ApiResponse apiResponse = ApiResponse.ok((Object)newContent, (!newContent.isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    private List<ViewInformacionProcessDTO> processViewExtractDataDto(List<ViewInformationProcess> process) {
        ArrayList<ViewInformacionProcessDTO> newList = new ArrayList<ViewInformacionProcessDTO>();
        for (ViewInformationProcess pro : process) {
            ViewInformacionProcessDTO processDTO = new ViewInformacionProcessDTO(this.cryptoService.decrypt(pro.getIdentification()), pro.getBiometricCode(), pro.getBiometricDate(), pro.getSignDate(), pro.getEstateSign(), this.extractChannel(pro.getCodigoInternoTws()));
            newList.add(processDTO);
        }
        return newList;
    }

    private String extractChannel(String value) {
        if (value == null) {
            return "";
        }
        try {
            String[] splittedValue = value.split(";");
            return splittedValue[3];
        }
        catch (Exception e) {
            return "";
        }
    }

    public ResponseEntity<ApiResponse<?>> getChartChannelByDate(LocalDateTime start, LocalDateTime end) {
        List listChannelsCount;
        ApiResponse apiResponse = ApiResponse.ok((Object)listChannelsCount, (!(listChannelsCount = this.viewInformationProcessDAO.getCountValuesPerChannels(start, end)).isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public SolicitudDAO getSolicitudDAO() {
        return this.solicitudDAO;
    }

    public CallbackBiometriaDAO getCallbackBiometriaDAO() {
        return this.callbackBiometriaDAO;
    }

    public CallbackFirmaDAO getCallbackFirmaDAO() {
        return this.callbackFirmaDAO;
    }

    public ViewInformationProcessDAO getViewInformationProcessDAO() {
        return this.viewInformationProcessDAO;
    }

    public CryptoMain getCryptoService() {
        return this.cryptoService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataReportTwsImpl)) {
            return false;
        }
        DataReportTwsImpl other = (DataReportTwsImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SolicitudDAO this$solicitudDAO = this.getSolicitudDAO();
        SolicitudDAO other$solicitudDAO = other.getSolicitudDAO();
        if (this$solicitudDAO == null ? other$solicitudDAO != null : !this$solicitudDAO.equals(other$solicitudDAO)) {
            return false;
        }
        CallbackBiometriaDAO this$callbackBiometriaDAO = this.getCallbackBiometriaDAO();
        CallbackBiometriaDAO other$callbackBiometriaDAO = other.getCallbackBiometriaDAO();
        if (this$callbackBiometriaDAO == null ? other$callbackBiometriaDAO != null : !this$callbackBiometriaDAO.equals(other$callbackBiometriaDAO)) {
            return false;
        }
        CallbackFirmaDAO this$callbackFirmaDAO = this.getCallbackFirmaDAO();
        CallbackFirmaDAO other$callbackFirmaDAO = other.getCallbackFirmaDAO();
        if (this$callbackFirmaDAO == null ? other$callbackFirmaDAO != null : !this$callbackFirmaDAO.equals(other$callbackFirmaDAO)) {
            return false;
        }
        ViewInformationProcessDAO this$viewInformationProcessDAO = this.getViewInformationProcessDAO();
        ViewInformationProcessDAO other$viewInformationProcessDAO = other.getViewInformationProcessDAO();
        if (this$viewInformationProcessDAO == null ? other$viewInformationProcessDAO != null : !this$viewInformationProcessDAO.equals(other$viewInformationProcessDAO)) {
            return false;
        }
        CryptoMain this$cryptoService = this.getCryptoService();
        CryptoMain other$cryptoService = other.getCryptoService();
        return !(this$cryptoService == null ? other$cryptoService != null : !this$cryptoService.equals(other$cryptoService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataReportTwsImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SolicitudDAO $solicitudDAO = this.getSolicitudDAO();
        result = result * 59 + ($solicitudDAO == null ? 43 : $solicitudDAO.hashCode());
        CallbackBiometriaDAO $callbackBiometriaDAO = this.getCallbackBiometriaDAO();
        result = result * 59 + ($callbackBiometriaDAO == null ? 43 : $callbackBiometriaDAO.hashCode());
        CallbackFirmaDAO $callbackFirmaDAO = this.getCallbackFirmaDAO();
        result = result * 59 + ($callbackFirmaDAO == null ? 43 : $callbackFirmaDAO.hashCode());
        ViewInformationProcessDAO $viewInformationProcessDAO = this.getViewInformationProcessDAO();
        result = result * 59 + ($viewInformationProcessDAO == null ? 43 : $viewInformationProcessDAO.hashCode());
        CryptoMain $cryptoService = this.getCryptoService();
        result = result * 59 + ($cryptoService == null ? 43 : $cryptoService.hashCode());
        return result;
    }

    public String toString() {
        return "DataReportTwsImpl(solicitudDAO=" + this.getSolicitudDAO() + ", callbackBiometriaDAO=" + this.getCallbackBiometriaDAO() + ", callbackFirmaDAO=" + this.getCallbackFirmaDAO() + ", viewInformationProcessDAO=" + this.getViewInformationProcessDAO() + ", cryptoService=" + this.getCryptoService() + ")";
    }

    public DataReportTwsImpl(SolicitudDAO solicitudDAO, CallbackBiometriaDAO callbackBiometriaDAO, CallbackFirmaDAO callbackFirmaDAO, ViewInformationProcessDAO viewInformationProcessDAO, CryptoMain cryptoService) {
        this.solicitudDAO = solicitudDAO;
        this.callbackBiometriaDAO = callbackBiometriaDAO;
        this.callbackFirmaDAO = callbackFirmaDAO;
        this.viewInformationProcessDAO = viewInformationProcessDAO;
        this.cryptoService = cryptoService;
    }
}

