/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.service.impl;

import com.reportes.exceptions.CustomException;
import com.reportes.logic.repository.CallbackBiometriaDAO;
import com.reportes.logic.repository.CallbackFirmaDAO;
import com.reportes.logic.service.CustomService;
import com.reportes.utils.ApiResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CustomServiceImpl
implements CustomService {
    private static final Logger log = LoggerFactory.getLogger(CustomServiceImpl.class);
    private final CallbackBiometriaDAO callbackBiometriaDAO;
    private final CallbackFirmaDAO callbackFirmaDAO;

    public ResponseEntity<ApiResponse<?>> findAllBiometricsByCode(String code) {
        List items;
        ApiResponse apiResponse = ApiResponse.ok((Object)items, (!(items = this.callbackBiometriaDAO.findByCodigo(code)).isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> findAllSignsByCode(String code) {
        List items;
        ApiResponse apiResponse = ApiResponse.ok((Object)items, (!(items = this.callbackFirmaDAO.findByCodigo(code)).isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> deleteBiometricByCode(String code) {
        try {
            List idTransactions = this.callbackBiometriaDAO.getIdByCode(code);
            if (idTransactions.isEmpty()) {
                throw new CustomException("NOT FOUND A REGISTER WITH CODE: " + code, HttpStatus.NOT_FOUND);
            }
            for (Long id : idTransactions) {
                this.callbackBiometriaDAO.deleteById((Object)id);
            }
            ApiResponse apiResponse = ApiResponse.ok((Object)"DELETED ITEMS", (boolean)false);
            return ResponseEntity.ok((Object)apiResponse);
        }
        catch (Exception e) {
            ApiResponse apiResponse = ApiResponse.customException((HttpStatus)HttpStatus.BAD_REQUEST, (String)e.getMessage());
            return ResponseEntity.badRequest().body((Object)apiResponse);
        }
    }

    public ResponseEntity<ApiResponse<?>> deleteSignByCode(String code) {
        try {
            List idTransactions = this.callbackFirmaDAO.getIdByCode(code);
            if (idTransactions.isEmpty()) {
                throw new CustomException("NOT FOUND A REGISTER WITH CODE: " + code, HttpStatus.NOT_FOUND);
            }
            for (Long id : idTransactions) {
                this.callbackFirmaDAO.deleteById((Object)id);
            }
            ApiResponse apiResponse = ApiResponse.ok((Object)"DELETED ITEMS", (boolean)false);
            return ResponseEntity.ok((Object)apiResponse);
        }
        catch (Exception e) {
            ApiResponse apiResponse = ApiResponse.customException((HttpStatus)HttpStatus.BAD_REQUEST, (String)e.getCause().getMessage());
            return ResponseEntity.badRequest().body((Object)apiResponse);
        }
    }

    public CustomServiceImpl(CallbackBiometriaDAO callbackBiometriaDAO, CallbackFirmaDAO callbackFirmaDAO) {
        this.callbackBiometriaDAO = callbackBiometriaDAO;
        this.callbackFirmaDAO = callbackFirmaDAO;
    }
}

