/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.service.impl;

import com.reportes.exceptions.CustomException;
import com.reportes.logic.data.BillindDTO;
import com.reportes.logic.entity.TBilling;
import com.reportes.logic.repository.BillingDAO;
import com.reportes.logic.service.BillingService;
import com.reportes.utils.ApiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class BillingServiceImpl
implements BillingService {
    private static final Logger log = LoggerFactory.getLogger(BillingServiceImpl.class);
    private final BillingDAO billingDAO;

    public ResponseEntity<ApiResponse<?>> saveNewBilling(BillindDTO billing) {
        try {
            Boolean existBilled = this.billingDAO.existsByCode(billing.getCode());
            if (existBilled.booleanValue()) {
                throw new CustomException("Ya existe un comprobante registrado para el c\u00f3digo '" + billing.getCode() + "'", HttpStatus.BAD_REQUEST);
            }
            String existCodeOnBiometric = this.billingDAO.findIdByBiometricCode4validateRegister(billing.getCode());
            if (existCodeOnBiometric == null) {
                throw new CustomException("No existe el registro solicitado.", HttpStatus.NOT_FOUND);
            }
            TBilling billingModel = TBilling.builder().code(billing.getCode()).descriptionBilling(billing.getDescription()).billedTo(billing.getBilledTo()).status(billing.getStatus()).reference(billing.getReference()).build();
            this.billingDAO.save((Object)billingModel);
            ApiResponse apiResponse = ApiResponse.ok((Object)"Comprobante registrado", (boolean)false);
            return ResponseEntity.ok((Object)apiResponse);
        }
        catch (CustomException e) {
            throw new CustomException(e.getMessage(), e.getHttpStatus());
        }
        catch (Exception e) {
            throw new CustomException("No se pudo culminar el proceso de factura para este producto.", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public BillingServiceImpl(BillingDAO billingDAO) {
        this.billingDAO = billingDAO;
    }
}

