/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.service.impl;

import com.reportes.exceptions.CustomException;
import com.reportes.logic.data.BillingStatusDTO;
import com.reportes.logic.data.UserBillDTO;
import com.reportes.logic.entity.firma.TSolicitudFirma;
import com.reportes.logic.repository.BillingDAO;
import com.reportes.logic.repository.SolicitudFirmaDAO;
import com.reportes.logic.service.BillingReportService;
import com.reportes.utils.ApiResponse;
import ec.tws2.crypto.run.CryptoMain;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class BillingReportServiceImpl
implements BillingReportService {
    private static final Logger log = LoggerFactory.getLogger(BillingReportServiceImpl.class);
    private final BillingDAO billingDAO;
    private final SolicitudFirmaDAO solicitudFirmaDAO;
    private final CryptoMain cryptoService;

    public ResponseEntity<ApiResponse<?>> findAllData4billByDate(LocalDateTime start, LocalDateTime end, int page, int size) {
        Page listBill;
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        ApiResponse apiResponse = ApiResponse.ok((Object)listBill, (!(listBill = this.billingDAO.findBilledDataBetweenDate(start, end, (Pageable)pageable)).isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> findAllData4billByDateAndBilled(LocalDateTime start, LocalDateTime end, int page, int size, boolean billed) {
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        Page listBill = this.billingDAO.findBilledByStatusBetweenDate(start, end, billed ? "1" : "0", (Pageable)pageable);
        ApiResponse apiResponse = ApiResponse.ok((Object)listBill, (!listBill.isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> getDataByStatusBill(LocalDateTime start, LocalDateTime end) {
        BillingStatusDTO listBill;
        ApiResponse apiResponse = ApiResponse.ok((Object)listBill, ((listBill = this.billingDAO.getBillingStatus(start, end)) != null ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> findByClienteDataCodigoBiometrico(String code) {
        TSolicitudFirma requestInfo = this.solicitudFirmaDAO.findByCodigoBiometrico(code);
        if (requestInfo == null) {
            throw new CustomException("No se encontro la informacion solicitada.", HttpStatus.NOT_FOUND);
        }
        UserBillDTO requestDecripted = UserBillDTO.builder().address(this.cryptoService.decrypt(requestInfo.getDomicilio())).identification(this.cryptoService.decrypt(requestInfo.getIdentificacion())).email(this.cryptoService.decrypt(requestInfo.getEmail())).fullName(this.cryptoService.decrypt(requestInfo.getNombres()) + " " + this.cryptoService.decrypt(requestInfo.getApellidoPaterno()) + " " + this.cryptoService.decrypt(requestInfo.getApellidoMaterno())).ciudad(requestInfo.getCiudad()).build();
        ApiResponse apiResponse = ApiResponse.ok((Object)requestDecripted, (boolean)true);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public BillingReportServiceImpl(BillingDAO billingDAO, SolicitudFirmaDAO solicitudFirmaDAO, CryptoMain cryptoService) {
        this.billingDAO = billingDAO;
        this.solicitudFirmaDAO = solicitudFirmaDAO;
        this.cryptoService = cryptoService;
    }
}

