/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.repository;

import com.reportes.logic.data.ChannelsCountDTO;
import com.reportes.logic.entity.vistas.ViewInformationProcess;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface ViewInformationProcessDAO
extends JpaRepository<ViewInformationProcess, String> {
    @Query(value="SELECT ((string_to_array(codigo_interno_tws, ';'))[4]) AS channel, count(*) as value FROM view_information_process ts where biometric_date between :start and :end group by ((string_to_array(codigo_interno_tws, ';'))[4])", nativeQuery=true)
    public List<ChannelsCountDTO> getCountValuesPerChannels(LocalDateTime var1, LocalDateTime var2);

    @Query(value="select vp from ViewInformationProcess vp where vp.biometricDate between :start AND :end order by vp.biometricDate desc")
    public Page<ViewInformationProcess> getRouteOfProcessByDate(LocalDateTime var1, LocalDateTime var2, Pageable var3);

    @Query(value="select vp from ViewInformationProcess vp where vp.biometricDate between :start AND :end and UPPER(vp.codigoInternoTws) like CONCAT('%', UPPER(:channel), '%') order by vp.biometricDate desc")
    public Page<ViewInformationProcess> getRouteOfProcessByDateAndLike(LocalDateTime var1, LocalDateTime var2, String var3, Pageable var4);

    @Query(value="select vp from ViewInformationProcess vp where vp.identification = :identification")
    public Page<ViewInformationProcess> findByIdentification(String var1, Pageable var2);

    @Query(value="select vp from ViewInformationProcess vp where vp.biometricCode = :code")
    public Page<ViewInformationProcess> getRouteOfProcessByCode(String var1, Pageable var2);
}

