/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.repository;

import com.reportes.logic.data.SolicitudStatusResponsesDTO;
import com.reportes.logic.data.StaticsDTO;
import com.reportes.logic.entity.TSolicitud;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface SolicitudDAO
extends JpaRepository<TSolicitud, Long> {
    @Query(value="SELECT ts.originalCallback FROM TSolicitud ts WHERE ts.codigoTransaccion = :transCode AND ts.tipo = :tipo ORDER BY ts.createdDate DESC LIMIT 1")
    public String getOriginalCallbackFromTransactionCode(String var1, String var2);

    public List<TSolicitud> findByCreatedDateBetween(LocalDateTime var1, LocalDateTime var2);

    @Query(value="SELECT COUNT(ts.tipo) AS tipoCount, ts.tipo, COUNT(CASE WHEN ts.status = 'OK' THEN 1 ELSE NULL END) AS okCount, COUNT(CASE WHEN ts.status <> 'OK' THEN 1 ELSE NULL END) AS errorCount FROM t_solicitud ts WHERE ts.created_date BETWEEN :start AND :end GROUP BY ts.tipo;", nativeQuery=true)
    public List<SolicitudStatusResponsesDTO> getSolicitudStatusResponses(LocalDateTime var1, LocalDateTime var2);

    @Query(value="SELECT COUNT(tcb.tipo) as value, tcb.tipo as type FROM t_callback_biometria tcb WHERE tcb.created_date BETWEEN :start AND :end GROUP BY tcb.tipo", nativeQuery=true)
    public List<StaticsDTO> getBiometricStatics(LocalDateTime var1, LocalDateTime var2);
}

