/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.repository;

import com.reportes.logic.data.DataConsumePerDayDTO;
import com.reportes.logic.data.DocumentsDTO;
import com.reportes.logic.data.SignedDocsStatus;
import com.reportes.logic.data.StaticsDTO;
import com.reportes.logic.entity.firma.TCallbackFirma;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface CallbackFirmaDAO
extends JpaRepository<TCallbackFirma, Long> {
    public List<TCallbackFirma> findByCodigo(String var1);

    @Query(value="SELECT tc.id FROM TCallbackFirma tc WHERE tc.codigo = :code")
    public List<Long> getIdByCode(String var1);

    @Query(value="select tcf.status as status, tcf.created_date as createdDate, tcf.codigo as code, tdf.tipo as type, tdf.motivo as reason  \nfrom t_callback_firma tcf inner join t_data_firma tdf on tcf.id_data_firma = tdf.id\nwhere tcf.created_date BETWEEN :start AND :end and tdf.motivo is not null order by tcf.created_date desc;", nativeQuery=true)
    public Page<SignedDocsStatus> getSignedDocsStatus(LocalDateTime var1, LocalDateTime var2, Pageable var3);

    @Query(value="select COUNT(tdf.motivo) as value, tdf.motivo as type from t_callback_firma tcf inner join t_data_firma tdf on tcf.id_data_firma = tdf.id where tcf.created_date BETWEEN :start AND :end and tdf.motivo is not null group by tdf.motivo;", nativeQuery=true)
    public List<StaticsDTO> getSignStatics(LocalDateTime var1, LocalDateTime var2);

    @Query(value="SELECT EXTRACT(DAY FROM tcf.created_date) AS day, count(tcf.codigo) AS value FROM t_callback_firma tcf  INNER JOIN t_data_firma tdf ON tcf.id_data_firma = tdf.id WHERE tcf.created_date BETWEEN :start AND :end AND tdf.motivo IS NOT null GROUP BY EXTRACT(DAY FROM tcf.created_date) ORDER BY day ASC;", nativeQuery=true)
    public List<DataConsumePerDayDTO> getTimeLineSignByDay(LocalDateTime var1, LocalDateTime var2);

    @Query(value="SELECT tc.data.codigo_documento as documentCode, tc.data.nombre as documentName FROM TCallbackFirma tc WHERE tc.codigo = :code AND (tc.data.archivo IS NOT NULL) order by tc.data.id")
    public List<DocumentsDTO> getDocumentsByCode(String var1);

    @Query(value="SELECT tc.data.archivo FROM TCallbackFirma tc WHERE tc.data.codigo_documento = :code AND (tc.data.archivo IS NOT NULL)")
    public String getDocumentByDocumentCode(String var1);
}

