/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.repository;

import com.reportes.logic.data.BillingStatusDTO;
import com.reportes.logic.entity.TBilling;
import com.reportes.logic.entity.vistas.ViewBilling;
import java.time.LocalDateTime;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface BillingDAO
extends JpaRepository<TBilling, Long> {
    @Query(value="SELECT vb FROM ViewBilling vb WHERE vb.biometricDate between :start and :end")
    public Page<ViewBilling> findBilledDataBetweenDate(LocalDateTime var1, LocalDateTime var2, Pageable var3);

    @Query(value="SELECT vb FROM ViewBilling vb WHERE (:value = '1' AND vb.idBilling IS NOT NULL) OR (:value = '0' AND vb.idBilling IS NULL) AND vb.biometricDate BETWEEN :start AND :end")
    public Page<ViewBilling> findBilledByStatusBetweenDate(LocalDateTime var1, LocalDateTime var2, String var3, Pageable var4);

    @Query(value="SELECT SUM(CASE WHEN id_billing IS NULL THEN 1 ELSE 0 END) AS notBilled, SUM(CASE WHEN id_billing IS NOT NULL THEN 1 ELSE 0 END) AS billed FROM view_billing WHERE biometric_date between :start and :end ", nativeQuery=true)
    public BillingStatusDTO getBillingStatus(LocalDateTime var1, LocalDateTime var2);

    public Boolean existsByCode(String var1);

    @Query(value="SELECT vb.biometricCode FROM ViewBilling vb WHERE vb.biometricCode= :code")
    public String findIdByBiometricCode4validateRegister(String var1);
}

