/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.controller;

import com.reportes.logic.service.CustomService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"private-controller"})
public class Tws2Controller {
    private static final Logger log = LoggerFactory.getLogger(Tws2Controller.class);
    private final CustomService customService;

    @DeleteMapping(value={"drop-biometric/{code}"})
    public ResponseEntity<?> deleteBiometric(@PathVariable String code) {
        return this.customService.deleteBiometricByCode(code);
    }

    @DeleteMapping(value={"drop-sign/{code}"})
    public ResponseEntity<?> deleteSign(@PathVariable String code) {
        return this.customService.deleteSignByCode(code);
    }

    @PostMapping(value={"get-biometrics/{code}"})
    public ResponseEntity<?> getBiometric(@PathVariable String code) {
        return this.customService.findAllBiometricsByCode(code);
    }

    @PostMapping(value={"get-signs/{code}"})
    public ResponseEntity<?> getSign(@PathVariable String code) {
        return this.customService.findAllSignsByCode(code);
    }

    public Tws2Controller(CustomService customService) {
        this.customService = customService;
    }
}

