/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.controller;

import com.reportes.logic.service.DataReportTws;
import com.reportes.utils.ApiResponse;
import com.reportes.utils.DateUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(value={"*"})
@RequestMapping(value={"reports"})
public class ReportsTwsController {
    private static final Logger log = LoggerFactory.getLogger(ReportsTwsController.class);
    private final DataReportTws dataReportTws;

    @PostMapping(value={"getStatusResponseByDate"})
    public ResponseEntity<ApiResponse<?>> getStatusResponseByDate(@RequestParam String start, @RequestParam String end) {
        return this.dataReportTws.getStatusResponseByDate(DateUtil.getLocalDateTimeFromString((String)start), DateUtil.getLocalDateTimeFromString((String)end));
    }

    @PostMapping(value={"getBiometricStatics"})
    public ResponseEntity<ApiResponse<?>> getBiometricStatics(@RequestParam String start, @RequestParam String end) {
        return this.dataReportTws.getBiometricStatics(DateUtil.getLocalDateTimeFromString((String)start), DateUtil.getLocalDateTimeFromString((String)end));
    }

    @PostMapping(value={"getTimeLineBiometricsPerDay"})
    public ResponseEntity<ApiResponse<?>> getTimeLineBiometricsPerDay(@RequestParam String start, @RequestParam String end) {
        return this.dataReportTws.getTimeLineBiometricsPerDay(DateUtil.getLocalDateTimeFromString((String)start), DateUtil.getLocalDateTimeFromString((String)end));
    }

    @PostMapping(value={"getSignedDocsStatus"})
    public ResponseEntity<ApiResponse<?>> getSignedDocsStatus(@RequestParam String start, @RequestParam String end, @RequestParam int page, @RequestParam int size) {
        return this.dataReportTws.getSignedDocsStatus(DateUtil.getLocalDateTimeFromString((String)start), DateUtil.getLocalDateTimeFromString((String)end), page, size);
    }

    @PostMapping(value={"getSignStatics"})
    public ResponseEntity<ApiResponse<?>> getSignStatics(@RequestParam String start, @RequestParam String end) {
        return this.dataReportTws.getSignStatics(DateUtil.getLocalDateTimeFromString((String)start), DateUtil.getLocalDateTimeFromString((String)end));
    }

    @PostMapping(value={"getTimeLineSignByDay"})
    public ResponseEntity<ApiResponse<?>> getTimeLineSignByDay(@RequestParam String start, @RequestParam String end) {
        return this.dataReportTws.getTimeLineSignByDay(DateUtil.getLocalDateTimeFromString((String)start), DateUtil.getLocalDateTimeFromString((String)end));
    }

    @PostMapping(value={"getRouteOfProcessByDate"})
    public ResponseEntity<ApiResponse<?>> getRouteOfProcessByDate(@RequestParam(required=false) String identification, @RequestParam String start, @RequestParam String end, @RequestParam int page, @RequestParam int size, @RequestParam String channel) {
        return this.dataReportTws.getRouteOfProcessByDate(DateUtil.getLocalDateTimeFromString((String)start), DateUtil.getLocalDateTimeFromString((String)end), page, size, channel, Optional.ofNullable(identification));
    }

    @PostMapping(value={"getRouteOfProcessByCode"})
    public ResponseEntity<ApiResponse<?>> getRouteOfProcessByCode(@RequestParam String code, @RequestParam int page, @RequestParam int size) {
        return this.dataReportTws.getRouteOfProcessByCode(code, page, size);
    }

    @PostMapping(value={"getChartChannel"})
    public ResponseEntity<ApiResponse<?>> getChartChannel(@RequestParam String start, @RequestParam String end) {
        return this.dataReportTws.getChartChannelByDate(DateUtil.getLocalDateTimeFromString((String)start), DateUtil.getLocalDateTimeFromString((String)end));
    }

    public ReportsTwsController(DataReportTws dataReportTws) {
        this.dataReportTws = dataReportTws;
    }
}

