/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.controller;

import com.reportes.exceptions.CustomException;
import com.reportes.logic.service.ReporteService;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(value={"*"})
@RequestMapping(value={"reporte-biometria"})
public class ReportController {
    private static final Logger log = LoggerFactory.getLogger(ReportController.class);
    @Autowired
    private ReporteService reporteService;

    @PostMapping(value={"/biometria"})
    public ResponseEntity<byte[]> generateBiometriaReport(@RequestParam String codigo) {
        try {
            String base64Report = this.reporteService.generateBase64PdfReport(codigo);
            byte[] pdfBytes = Base64.getDecoder().decode(base64Report);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_PDF);
            headers.setContentDisposition(ContentDisposition.inline().filename("BiometriaReport.pdf").build());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)pdfBytes);
        }
        catch (CustomException e) {
            log.error("ERROR AL CONSUMIR EL REPORTE ", (Throwable)e);
            throw new CustomException(e.getMessage(), e.getHttpStatus());
        }
        catch (Exception e) {
            log.error("ERROR AL CONSUMIR EL REPORTE: ", (Throwable)e);
            throw new CustomException("Ocurri\u00f3 un error al consumir el reporte.", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

