/*
 * Decompiled with CFR 0.152.
 */
package com.reportes.logic.controller;

import com.reportes.logic.data.BillindDTO;
import com.reportes.logic.service.BillingReportService;
import com.reportes.logic.service.BillingService;
import com.reportes.utils.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(value={"*"})
@RequestMapping(value={"billing"})
public class BillingController {
    private static final Logger log = LoggerFactory.getLogger(BillingController.class);
    private final BillingService billingService;
    private final BillingReportService billingReportService;

    @PostMapping(value={"new"})
    public ResponseEntity<?> registerNewBill(@RequestBody BillindDTO billing) {
        return this.billingService.saveNewBilling(billing);
    }

    @PostMapping(value={"list"})
    public ResponseEntity<?> findAllData4billByDate(@RequestParam String start, @RequestParam String end, @RequestParam int page, @RequestParam int size) {
        return this.billingReportService.findAllData4billByDate(DateUtil.getLocalDateTimeFromString((String)start), DateUtil.getLocalDateTimeFromString((String)end), page, size);
    }

    @PostMapping(value={"list-billed-status"})
    public ResponseEntity<?> findAllData4billByDateAndBilled(@RequestParam String start, @RequestParam String end, @RequestParam int page, @RequestParam int size, @RequestParam Boolean billed) {
        return this.billingReportService.findAllData4billByDateAndBilled(DateUtil.getLocalDateTimeFromString((String)start), DateUtil.getLocalDateTimeFromString((String)end), page, size, billed.booleanValue());
    }

    @PostMapping(value={"list-status-chart"})
    public ResponseEntity<?> getDataByStatusBill(@RequestParam String start, @RequestParam String end) {
        return this.billingReportService.getDataByStatusBill(DateUtil.getLocalDateTimeFromString((String)start), DateUtil.getLocalDateTimeFromString((String)end));
    }

    @PostMapping(value={"findByClienteDataCodigoBiometrico/{code}"})
    public ResponseEntity<?> getDataByStatusBill(@PathVariable String code) {
        return this.billingReportService.findByClienteDataCodigoBiometrico(code);
    }

    public BillingController(BillingService billingService, BillingReportService billingReportService) {
        this.billingService = billingService;
        this.billingReportService = billingReportService;
    }
}

