/*
 * Decompiled with CFR 0.152.
 */
package com.firma.utils;

import com.firma.exceptions.CustomException;
import com.firma.logic.model.Stamp;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class SignatureUtils {
    private static final Logger log = LoggerFactory.getLogger(SignatureUtils.class);

    public static KeyStore loadKeyStore(String path, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (FileInputStream fis = new FileInputStream(path);){
            keyStore.load(fis, password.toCharArray());
        }
        return keyStore;
    }

    public static PrivateKey getPrivateKey(KeyStore keyStore, String alias, String password) throws Exception {
        return (PrivateKey)keyStore.getKey(alias, password.toCharArray());
    }

    public static Certificate[] getCertificateChain(KeyStore keyStore, String alias) throws Exception {
        return keyStore.getCertificateChain(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPdfWithTextAndDate(String nombreFirmante, Calendar fecha, String filePath, int pageNumber, float startX, float startY) {
        String template = "Firmado electr\u00f3nicamente por:\n{nombre}\nFecha: {fecha}";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss 'UTC'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String formattedDate = sdf.format(fecha.getTime());
        template = template.replace("{nombre}", nombreFirmante).replace("{fecha}", formattedDate);
        PDDocument document = null;
        try {
            document = PDDocument.load((File)new File(filePath));
            if (pageNumber < 0 || pageNumber >= document.getNumberOfPages()) {
                int pageNumberPlusOne = pageNumber + 1;
                throw new CustomException("No se encontr\u00f3 la p\u00e1gina ingresada: " + pageNumberPlusOne, HttpStatus.BAD_REQUEST);
            }
            PDPage page = document.getPage(pageNumber);
            try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                String[] lines;
                contentStream.setFont((PDFont)PDType1Font.HELVETICA_BOLD_OBLIQUE, 8.0f);
                float leading = 14.5f;
                for (String line : lines = template.split("\n")) {
                    contentStream.beginText();
                    contentStream.newLineAtOffset(startX, startY);
                    contentStream.showText(line);
                    contentStream.endText();
                    startY -= leading;
                }
            }
            document.save(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createPdfWithMultipleStamps(List<Stamp> stamps, String base64Pdf, String outputFilePath) {
        PDDocument document = null;
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(base64Pdf);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(decodedBytes);
            document = PDDocument.load((InputStream)inputStream);
            for (Stamp stamp : stamps) {
                if (stamp.getPageNumber() < 0 || stamp.getPageNumber() >= document.getNumberOfPages()) {
                    int pageNumberPlusOne = stamp.getPageNumber() + 1;
                    log.error("No se encontr\u00f3 la p\u00e1gina ingresada: " + pageNumberPlusOne);
                    throw new CustomException("No se encontr\u00f3 la p\u00e1gina ingresada: " + pageNumberPlusOne, HttpStatus.BAD_REQUEST);
                }
                PDPage page = document.getPage(stamp.getPageNumber());
                String template = "Firmado electr\u00f3nicamente por:\n{nombre}\nFecha: {fecha}";
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                String formattedDate = stamp.getFecha().format(formatter);
                template = template.replace("{nombre}", stamp.getNombreFirmante()).replace("{fecha}", formattedDate);
                try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                    contentStream.setFont((PDFont)PDType1Font.HELVETICA_BOLD_OBLIQUE, 8.0f);
                    float leading = 14.5f;
                    String[] lines = template.split("\n");
                    float startY = stamp.getStartY();
                    for (String line : lines) {
                        contentStream.beginText();
                        contentStream.newLineAtOffset(stamp.getStartX(), startY);
                        contentStream.showText(line);
                        contentStream.endText();
                        startY -= leading;
                    }
                }
            }
            Path tempDir = Paths.get(outputFilePath, new String[0]);
            if (!Files.exists(tempDir, new LinkOption[0])) {
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            String tempFileName = UUID.randomUUID().toString();
            Path tempFile = Files.createTempFile(tempDir, tempFileName, ".pdf", new FileAttribute[0]);
            document.save(tempFile.toFile());
            document.close();
            byte[] signedPdfBytes = Files.readAllBytes(tempFile);
            Files.delete(tempFile);
            String string = Base64.getEncoder().encodeToString(signedPdfBytes);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

