/*
 * Decompiled with CFR 0.152.
 */
package com.firma.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.firma.exceptions.CustomException;
import com.firma.logic.data.DocumentsModel;
import com.firma.logic.data.DocumentsSplitModel;
import com.firma.logic.service.FirmaService;
import com.firma.utils.DocumentUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ConvertJsonService {
    private static final Logger log = LoggerFactory.getLogger(ConvertJsonService.class);
    private final ObjectMapper objectMapper;
    private final FirmaService firmaService;
    private final Environment env;

    public String transformStringToListDocumentModel(String documentos, String fullName) {
        try {
            List docs = (List)this.objectMapper.readValue(documentos, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            log.info("DOCUMENTOS TRANSFORMADOS CORRECTAMENTE TAMANIO DE LA LISTA: {}", (Object)docs.size());
            if (docs.isEmpty()) {
                throw new CustomException("LA LISTA DE DOCUMENTOS NO PUEDE ESTAR VACIA", HttpStatus.BAD_REQUEST);
            }
            List stampedDocuments = this.signAndReplaceDocument(docs, fullName);
            log.info("LISTA DE DOCUMENTOS TRANSFORMADOS Y ESTAMPADOS CORRECTAMENTE");
            String jsonString = this.transformListDocumentsModelToString(stampedDocuments);
            return jsonString;
        }
        catch (CustomException e) {
            log.error("EL FORMATO DE DOCUMENTOS ENVIADOS NO ES CORRECTO: ", (Throwable)e);
            throw new CustomException(e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            log.error("ERROR AL CONVERTIR A UNA LISTA LOS DOCUMENTOS: ", (Throwable)e);
            throw new CustomException("EL FORMATO DE DOCUMENTOS ENVIADOS NO ES CORRECTO", HttpStatus.BAD_REQUEST);
        }
    }

    public String transformListDocumentsModelToString(List<DocumentsModel> documents) {
        try {
            log.info("TRANSFORMANDO DOCUMENTOS A STRING");
            String jsonString = this.objectMapper.writeValueAsString(documents);
            log.info("LISTA CONVERTIDA A STRING NUEVAMENTE");
            return jsonString;
        }
        catch (Exception e) {
            log.error("ERROR AL CONVERTIR A UNA LISTA LOS DOCUMENTOS: ", (Throwable)e);
            throw new CustomException("EL FORMATO DE DOCUMENTOS ENVIADOS NO ES CORRECTO", HttpStatus.BAD_REQUEST);
        }
    }

    public List<DocumentsSplitModel> transformStringToListDocumentSplitModel(String documentos) {
        try {
            List docs = (List)this.objectMapper.readValue(documentos, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            log.info("DOCUMENTOS TRANSFORMADOS CORRECTAMENTE TAMANIO DE LA LISTA: {}", (Object)docs.size());
            if (docs.isEmpty()) {
                throw new CustomException("LA LISTA DE DOCUMENTOS NO PUEDE ESTAR VACIA", HttpStatus.BAD_REQUEST);
            }
            return docs;
        }
        catch (CustomException e) {
            log.error("EL FORMATO DE DOCUMENTOS ENVIADOS NO ES CORRECTO: ", (Throwable)e);
            throw new CustomException(e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            log.error("ERROR AL CONVERTIR A UNA LISTA LOS DOCUMENTOS: ", (Throwable)e);
            throw new CustomException("EL FORMATO DE DOCUMENTOS ENVIADOS NO ES CORRECTO", HttpStatus.BAD_REQUEST);
        }
    }

    public List<DocumentsModel> signAndReplaceDocument(List<DocumentsModel> documents, String fullName) {
        String tempPathSaveDoc = this.env.getProperty("ruta.temporal.firma");
        for (DocumentsModel doc : documents) {
            String base64;
            log.warn("coordenadas stamp: {}", (Object)doc.getCoordenadaStamp());
            if (doc.getCoordenadaStamp() == null) continue;
            String coordenadas = doc.getCoordenadaStamp();
            if (!(coordenadas = coordenadas.replace(" ", "")).isEmpty() && !coordenadas.isBlank()) {
                base64 = doc.getArchivoBase64();
                String docBase64Stamped = this.firmaService.restampSignJust(base64, coordenadas, fullName);
                if (docBase64Stamped == null) {
                    throw new CustomException("NO SE PUDO REALIZAR EL ESTAMPADO EN EL DOCUMENTO: " + doc.getNombre(), HttpStatus.BAD_REQUEST);
                }
                String rotatedDocuemntBase64 = DocumentUtils.allPagesVertical((String)docBase64Stamped, (String)tempPathSaveDoc);
                doc.setArchivoBase64(rotatedDocuemntBase64);
                doc.setCoordenadaStamp(null);
                continue;
            }
            base64 = doc.getArchivoBase64();
            String rotatedDocuemntBase64 = DocumentUtils.allPagesVertical((String)base64, (String)tempPathSaveDoc);
            doc.setArchivoBase64(rotatedDocuemntBase64);
        }
        return documents;
    }

    public ConvertJsonService(ObjectMapper objectMapper, FirmaService firmaService, Environment env) {
        this.objectMapper = objectMapper;
        this.firmaService = firmaService;
        this.env = env;
    }
}

