/*
 * Decompiled with CFR 0.152.
 */
package com.firma.logic.service.impl;

import com.firma.exceptions.CustomException;
import com.firma.logic.data.DocumentsModel;
import com.firma.logic.data.DocumentsSplitModel;
import com.firma.logic.data.ResponseBiometriaUanataca;
import com.firma.logic.data.ResponseFirmaUanataca;
import com.firma.logic.entity.TSolicitud;
import com.firma.logic.entity.biometria.TCallbackBiometria;
import com.firma.logic.entity.firma.TCallbackFirma;
import com.firma.logic.repository.SolicitudDAO;
import com.firma.logic.restTemplate.service.UanatacaServiceAPI;
import com.firma.logic.service.CanalService;
import com.firma.logic.service.DataBaseService;
import com.firma.logic.service.OrigenService;
import com.firma.logic.service.SolicitudFirmaService;
import com.firma.logic.service.UanatacaService;
import com.firma.utils.ApiResponse;
import com.firma.utils.ConvertJsonService;
import com.firma.utils.DocumentUtils;
import com.firma.utils.Utils;
import ec.tws2.crypto.run.CryptoMain;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UanatacaServiceImpl
implements UanatacaService {
    private static final Logger log = LoggerFactory.getLogger(UanatacaServiceImpl.class);
    private final UanatacaServiceAPI uanatacaApi;
    private final SolicitudFirmaService solicitudFirmaService;
    private final DataBaseService baseService;
    private final SolicitudDAO solicitudDAO;
    private final CryptoMain cryptoService;
    private final Environment env;
    private final CanalService canalService;
    private final OrigenService origenService;
    private final ConvertJsonService convertJsonService;

    public ResponseEntity<?> solicitarBiometria(String identificacion, String callback, String codigoInterno, String motivo, String origen, String canal) {
        log.info("Solicitando la biometria");
        if (codigoInterno == null) {
            codigoInterno = UUID.randomUUID().toString();
        }
        canal = this.canalService.validarCanal(canal);
        origen = this.origenService.validarOrigen(origen);
        String tipoSolicitud = this.env.getProperty("tws.tipotrans.bio");
        String schemeBiometria = this.env.getProperty("tws.schema.biometria");
        String codigoInternoTws = UUID.randomUUID().toString();
        String buildedCodigoInterno = schemeBiometria.replace("{cliente}", identificacion).replace("{canal}", canal.toUpperCase()).replace("{codigoInternoTws}", codigoInternoTws).replace("{codigoInterno}", codigoInterno).replace("{origen}", origen);
        String tokenEncripted = this.baseService.getTokenFromJti();
        String tokenUA = this.cryptoService.decrypt(tokenEncripted);
        String twsCallback = this.env.getProperty("tws.callback.biometria");
        ResponseBiometriaUanataca response = this.uanatacaApi.getBiometriaUanataca(identificacion, twsCallback, buildedCodigoInterno, motivo, tokenUA);
        String codigoTransaccion = response.getStatus() == 200 ? response.getData().getCodigo() : null;
        String status = codigoTransaccion != null ? "OK" : "ERROR: " + response.getMessages();
        TSolicitud solicitud = new TSolicitud(this.cryptoService.encriptar(callback), this.cryptoService.encriptar(twsCallback), codigoTransaccion, codigoInterno, buildedCodigoInterno, tipoSolicitud, status, tokenEncripted);
        this.solicitudDAO.save((Object)solicitud);
        log.info("informacion del proceso guardada correctamente");
        if (response.getStatus() == 200) {
            return new ResponseEntity((Object)ApiResponse.ok((int)response.getStatus(), (Object)response.getData()), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)ApiResponse.error((int)response.getStatus(), (Map)response.getMessages()), (HttpStatusCode)HttpStatus.valueOf((int)response.getStatus()));
    }

    public ResponseEntity<?> solicitarFirma(String codigoBiometrico, String codigoCliente, String identificacion, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String documentos, String origen, String callback, String canal) {
        log.info("Solicitando la FIRMA");
        canal = this.canalService.validarCanal(canal);
        origen = this.origenService.validarOrigen(origen);
        this.solicitudFirmaService.saveSolicitudFima(codigoBiometrico, codigoCliente, identificacion, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, origen, callback);
        String tipoSolicitud = this.env.getProperty("tws.tipotrans.fir");
        String tokenEncripted = this.baseService.getTokenFromJti();
        String tokenUA = this.cryptoService.decrypt(tokenEncripted);
        String twsCallback = this.env.getProperty("tws.callback.firma");
        String schemeFirma = this.env.getProperty("tws.schema.firma");
        String codigoInternoTws = UUID.randomUUID().toString();
        String buildedCodigoInterno = schemeFirma.replace("{cliente}", identificacion).replace("{canal}", canal.toUpperCase()).replace("{codigoInternoTws}", codigoInternoTws).replace("{codigoInterno}", codigoInternoTws).replace("{origen}", origen);
        ResponseFirmaUanataca response = this.uanatacaApi.getFirmaUanataca(codigoBiometrico, buildedCodigoInterno, identificacion, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, documentos, twsCallback, tokenUA);
        String status = response.getStatus() == 200 ? "OK" : "ERROR: " + response.getMessages();
        TSolicitud solicitud = new TSolicitud(this.cryptoService.encriptar(callback), this.cryptoService.encriptar(twsCallback), codigoBiometrico, codigoCliente, buildedCodigoInterno, tipoSolicitud, status, tokenEncripted);
        this.solicitudDAO.save((Object)solicitud);
        log.info("informacion del proceso guardada correctamente");
        if (response.getStatus() == 200) {
            return new ResponseEntity((Object)ApiResponse.ok((int)response.getStatus(), (Object)response.getData()), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)ApiResponse.error((int)response.getStatus(), (Map)response.getMessages()), (HttpStatusCode)HttpStatus.valueOf((int)response.getStatus()));
    }

    public void reenviarCallbackBiometria(TCallbackBiometria callback, String tipo) {
        try {
            String code = callback.getCodigo();
            String originalCallback = this.baseService.getOriginalCallbackFromProcessCode(code, tipo);
            String originalCallbackDecripted = this.cryptoService.decrypt(originalCallback);
            this.uanatacaApi.postReturningCallbackBiometria(callback, originalCallbackDecripted);
        }
        catch (Exception e) {
            log.error("ERROR AL REALIZAR EL POST DE BIOMETRIA A LA 29", (Throwable)e);
        }
    }

    public void reenviarCallbackFirma(TCallbackFirma callback, String tipo) {
        try {
            String code = callback.getCodigo();
            String originalCallback = this.baseService.getOriginalCallbackFromProcessCode(code, tipo);
            String originalCallbackDecripted = this.cryptoService.decrypt(originalCallback);
            if (callback.getData() != null && !Utils.isPrincipalDocument((String)callback.getData().getNombre())) {
                log.info("ESTE CALLBACK NO FUE NOTIFICADO PUESTO QUE NO ES EL DOCUMENTO PRINCIPAL");
            } else {
                this.uanatacaApi.postReturningCallbackFirma(callback, originalCallbackDecripted);
                log.info("CALLBACK NOTIFICADO CORRECTAMENTE");
            }
        }
        catch (Exception e) {
            log.error("ERROR AL REALIZAR EL POST DE FIRMAS A LA 29", (Throwable)e);
        }
    }

    public String validarDocumentoSegmentadosTransformadosString(String documentos, String fullName) {
        String tempPathSaveDoc = this.env.getProperty("ruta.temporal.firma");
        List documentsSplitModel = this.convertJsonService.transformStringToListDocumentSplitModel(documentos);
        ArrayList<DocumentsModel> finalDocs = new ArrayList<DocumentsModel>();
        for (DocumentsSplitModel doc : documentsSplitModel) {
            doc.setArchivoBase64(DocumentUtils.allPagesVertical((String)doc.getArchivoBase64(), (String)tempPathSaveDoc));
            log.info("documentos rotados");
            if (doc.getDocumentosSegmentados() == null) {
                finalDocs.add(doc.toDocumentsModel());
                continue;
            }
            finalDocs.addAll(doc.toDocumentsModelList());
        }
        if (finalDocs.size() > 10) {
            throw new CustomException("El m\u00e1ximo de documentos permitidos incluyendo las segmentaciones es 10. Por favor, ajuste su solicitud.", HttpStatus.BAD_REQUEST);
        }
        List stampedDocuments = this.convertJsonService.signAndReplaceDocument(finalDocs, fullName);
        return this.convertJsonService.transformListDocumentsModelToString(stampedDocuments);
    }

    public UanatacaServiceImpl(UanatacaServiceAPI uanatacaApi, SolicitudFirmaService solicitudFirmaService, DataBaseService baseService, SolicitudDAO solicitudDAO, CryptoMain cryptoService, Environment env, CanalService canalService, OrigenService origenService, ConvertJsonService convertJsonService) {
        this.uanatacaApi = uanatacaApi;
        this.solicitudFirmaService = solicitudFirmaService;
        this.baseService = baseService;
        this.solicitudDAO = solicitudDAO;
        this.cryptoService = cryptoService;
        this.env = env;
        this.canalService = canalService;
        this.origenService = origenService;
        this.convertJsonService = convertJsonService;
    }
}

