/*
 * Decompiled with CFR 0.152.
 */
package com.firma.logic.service.impl;

import com.firma.logic.entity.vistas.ReporteBiometria29;
import com.firma.logic.repository.ReporteBiometriaDAO;
import com.firma.logic.service.ReporteService;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReporteServiceImpl
implements ReporteService {
    @Autowired
    ReporteBiometriaDAO reporteBiometriaDAO;

    public String generateBase64PdfReport(String codigo) throws Exception {
        ReporteBiometria29 reporte = this.reporteBiometriaDAO.findLatestByCodigo(codigo);
        ClassPathResource resource = new ClassPathResource("reports/reporte.jasper");
        InputStream reportStream = resource.getInputStream();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("nombre_apellido", ReporteServiceImpl.extractNombreCompleto((String)reporte.getMetadata()));
        parameters.put("fecha_nacimiento", reporte.getFechaNacimiento());
        parameters.put("identificador", reporte.getIdentificacion());
        parameters.put("codigo_dactilar", reporte.getCodigoDactilar());
        parameters.put("estado_civil", reporte.getEstadoCivil());
        parameters.put("fecha_expedicion", reporte.getFechaEmision());
        parameters.put("lugar_nacimiento", ReporteServiceImpl.extractLugarNacimiento((String)reporte.getMetadata()));
        parameters.put("nacionalidad", reporte.getNacionalidad());
        parameters.put("uuid", reporte.getCodigo());
        parameters.put("coincidencia_rostro", reporte.getRostroSimilitud().toString());
        parameters.put("coincidencia_rostro_frontal", reporte.getRostroSimilitudFrontal().toString());
        parameters.put("coincidencia_selfie", reporte.getRostroSimilitudSelfie().toString());
        parameters.put("numero_intentos", reporte.getIntentos());
        parameters.put("firma_documento", reporte.getType());
        parameters.put("fecha_hora_firma", reporte.getSign_date());
        parameters.put("img_front", reporte.getImgFrontal());
        parameters.put("img_back", reporte.getImgReverso());
        parameters.put("img_selfie", reporte.getImgSelfie());
        JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)reportStream, parameters, (JRDataSource)new JREmptyDataSource());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
        byte[] pdfBytes = outputStream.toByteArray();
        return Base64.getEncoder().encodeToString(pdfBytes);
    }

    public static String extractNombreCompleto(String text) {
        Pattern pattern = Pattern.compile("APELLIDOS\\s+Y\\s+NOMBRES\\s+(.*?)\\s+LUGAR", 2);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String nombreCompleto = matcher.group(1).trim();
            String[] partesNombre = nombreCompleto.split("\\s+");
            if (partesNombre.length >= 4) {
                String primerNombre = partesNombre[2];
                String segundoNombre = partesNombre[3];
                String apellidos = partesNombre[0] + " " + partesNombre[1];
                return primerNombre + " " + segundoNombre + " " + apellidos;
            }
            return "Nombre no encontrado";
        }
        return "Nombre no encontrado";
    }

    public static String extractLugarNacimiento(String text) {
        Pattern pattern = Pattern.compile("LUGAR\\s+(.*?)\\s+FECHA", 2);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String lugarNacimiento = matcher.group(1).trim();
            lugarNacimiento = lugarNacimiento.replaceAll("(?i)de\\s*nacimiento|denacimiento", "").trim();
            return lugarNacimiento;
        }
        return "Lugar de nacimiento no encontrado";
    }
}

