/*
 * Decompiled with CFR 0.152.
 */
package com.firma.logic.service.impl;

import com.firma.logic.entity.TOrigen;
import com.firma.logic.repository.OrigenDAO;
import com.firma.logic.service.OrigenService;
import com.firma.utils.ApiResponse;
import com.firma.utils.Utils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class OrigenServiceImpl
implements OrigenService {
    private static final Logger log = LoggerFactory.getLogger(OrigenServiceImpl.class);
    private final OrigenDAO origenDAO;

    public ResponseEntity<ApiResponse<?>> registrarNuevoOrigen(String origen) {
        origen = Utils.limpiarCamposSoloLetras((String)origen);
        this.origenDAO.save((Object)new TOrigen(origen));
        ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)"Registro creado");
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> actualizarOrigen(String origen, Boolean activo) {
        TOrigen origenEncontrado = this.origenDAO.findByOrigen(origen = Utils.limpiarCamposSoloLetras((String)origen));
        if (origenEncontrado != null) {
            origenEncontrado.setOrigen(origen);
            origenEncontrado.setActivo(activo);
            this.origenDAO.save((Object)origenEncontrado);
            ApiResponse apiResponse = ApiResponse.ok((int)201, (Object)"Registro actualizado");
            return ResponseEntity.ok((Object)apiResponse);
        }
        ApiResponse apiResponse = ApiResponse.error((int)400, (String)"Registro no encontrado");
        return ResponseEntity.badRequest().body((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> findAllOrigenes() {
        List origenes = this.origenDAO.findAll();
        ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)origenes);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public ResponseEntity<ApiResponse<?>> findAllOrigenes4combo() {
        List origenes = this.origenDAO.findListOrigens();
        ApiResponse apiResponse = ApiResponse.ok((int)200, (Object)origenes);
        return ResponseEntity.ok((Object)apiResponse);
    }

    public String validarOrigen(String origen) {
        Boolean existeOrigen;
        if (origen == null || origen.isBlank()) {
            origen = "ORIGEN_SIN_ASIGNAR";
        }
        if (!(existeOrigen = this.origenDAO.existsByOrigen(origen = Utils.limpiarCamposSoloLetras((String)origen))).booleanValue()) {
            TOrigen nuevoOrigen = new TOrigen(origen);
            this.origenDAO.save((Object)nuevoOrigen);
        }
        return origen;
    }

    public OrigenServiceImpl(OrigenDAO origenDAO) {
        this.origenDAO = origenDAO;
    }
}

