/*
 * Decompiled with CFR 0.152.
 */
package com.firma;

import ec.tws2.crypto.run.CryptoMain;
import java.util.TimeZone;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestTemplate;

@EnableAsync
@SpringBootApplication
@EnableJpaAuditing
@EnableScheduling
@EnableTransactionManagement
public class BackFirma
implements CommandLineRunner {
    private final Environment env;

    public static void main(String[] args) {
        TimeZone.setDefault(TimeZone.getTimeZone("America/Guayaquil"));
        SpringApplication.run(BackFirma.class, (String[])args);
    }

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    CryptoMain cryptoService() {
        return new CryptoMain();
    }

    public void run(String ... args) throws Exception {
        System.out.println("===================================================");
        System.out.println("INICIO DE LA APLICACION");
        System.out.println("AMBIENTE: " + this.env.getProperty("ambiente"));
        System.out.println("DOMINIO: " + this.env.getProperty("tws.domain"));
        System.out.println("CLIENTE: " + this.env.getProperty("tws.client.reference"));
        System.out.println("RUTA FIRMADO: " + this.env.getProperty("ruta.temporal.firma"));
        System.out.println("===================================================");
    }

    public BackFirma(Environment env) {
        this.env = env;
    }
}

