/*
 * Decompiled with CFR 0.152.
 */
package com.firma.utils;

import com.firma.exceptions.CustomException;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static List<int[]> tranformarStringObtenerSeparacionPaginas(String ranges) {
        try {
            ArrayList<int[]> pageRanges = new ArrayList<int[]>();
            String[] rangePairs = ranges.split(",");
            if (rangePairs.length > 10) {
                throw new CustomException("Se han enviado demasiados rangos. El m\u00e1ximo permitido es 10. Por favor, ajuste su solicitud.", HttpStatus.BAD_REQUEST);
            }
            String[] stringArray = rangePairs;
            int n = rangePairs.length;
            int n2 = 0;
            while (n2 < n) {
                String range = stringArray[n2];
                String[] bounds = range.split("-");
                if (bounds.length != 2) {
                    throw new CustomException("Formato de rango inv\u00e1lido: '" + range + "'. Cada rango debe estar en el formato 'inicio-fin', ej. '1-3,4-6'.", HttpStatus.BAD_REQUEST);
                }
                try {
                    int start = Integer.parseInt(bounds[0].trim());
                    int end = Integer.parseInt(bounds[1].trim());
                    if (start > end) {
                        throw new CustomException("El rango '" + range + "' no es v\u00e1lido. El valor inicial debe ser menor o igual al valor final.", HttpStatus.BAD_REQUEST);
                    }
                    pageRanges.add(new int[]{start, end});
                }
                catch (NumberFormatException e) {
                    throw new CustomException("Los valores del rango deben ser n\u00fameros enteros. Error en: '" + range + "'.", HttpStatus.BAD_REQUEST);
                }
                ++n2;
            }
            return pageRanges;
        }
        catch (CustomException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CustomException("Ocurri\u00f3 un error inesperado al procesar los rangos de p\u00e1ginas. Por favor revise su solicitud.", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public static String extraerPaginasBase64(String range, String originalBase64) {
        try {
            int end;
            int start;
            byte[] pdfBytes = Base64.getDecoder().decode(originalBase64);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
            PDDocument originalDocument = PDDocument.load((InputStream)inputStream);
            String[] bounds = range.split("-");
            if (bounds.length != 2) {
                throw new CustomException("Formato de rango inv\u00e1lido: '" + range + "'. Debe estar en el formato 'inicio-fin', ej. '1-3'.", HttpStatus.BAD_REQUEST);
            }
            try {
                start = Integer.parseInt(bounds[0].trim());
                end = Integer.parseInt(bounds[1].trim());
            }
            catch (NumberFormatException e) {
                throw new CustomException("Los valores del rango deben ser n\u00fameros enteros. Error en: '" + range + "'.", HttpStatus.BAD_REQUEST);
            }
            if (start > end || start < 1 || end > originalDocument.getNumberOfPages()) {
                throw new CustomException("El rango '" + range + "' no es v\u00e1lido. Verifique que los valores sean v\u00e1lidos para el documento.", HttpStatus.BAD_REQUEST);
            }
            PDDocument extractedDocument = new PDDocument();
            int i = start;
            while (i <= end) {
                PDPage page = originalDocument.getPage(i - 1);
                extractedDocument.addPage(page);
                ++i;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            extractedDocument.save((OutputStream)outputStream);
            extractedDocument.close();
            byte[] extractedBytes = outputStream.toByteArray();
            return Base64.getEncoder().encodeToString(extractedBytes);
        }
        catch (CustomException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CustomException("Ocurri\u00f3 un error inesperado al procesar el rango de p\u00e1ginas. Por favor revise su solicitud.", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public static String limpiarCamposSoloLetras(String valor) {
        valor = valor.replace(" ", "_");
        valor = valor.replaceAll("[^0-9a-zA-Z_]", "");
        return valor.toUpperCase();
    }

    public static Boolean isPdfFile(String base64String) {
        byte[] data = Base64.getDecoder().decode(base64String);
        String headerStr = new String(data, 0, 5);
        return headerStr.equals("%PDF-");
    }

    public static int getPageNumber(byte[] pdfContent) {
        try {
            PdfReader reader = new PdfReader((InputStream)new ByteArrayInputStream(pdfContent));
            PdfDocument document = new PdfDocument(reader);
            int numberOfPages = document.getNumberOfPages();
            document.close();
            reader.close();
            return numberOfPages;
        }
        catch (Exception e) {
            throw new CustomException("No se ha podido identificar la p\u00e1gina a firmar", HttpStatus.BAD_REQUEST);
        }
    }

    public static Map validateBiometricObject(Map<String, Object> biometricObject) {
        log.info("validate json");
        Object tipo = biometricObject.get("tipo");
        Object error = biometricObject.get("error");
        if (tipo.equals("PRUEBA_VIDA")) {
            Map concatErrMessage;
            Map indicadores = (Map)biometricObject.get("indicadores");
            Object messages = biometricObject.get("messages");
            Map validatedMessage = Utils.validateMessageStringList((Object)messages);
            if (validatedMessage != null) {
                biometricObject.put("messages", validatedMessage);
            }
            if ((concatErrMessage = Utils.constructErrorMessageMap((Object)error, (Object)biometricObject.get("messages"))) != null) {
                biometricObject.put("messages", concatErrMessage);
            }
            if (indicadores != null) {
                Object reverso = indicadores.get("reverso");
                Object anverso = indicadores.get("anverso");
                if (reverso instanceof List) {
                    indicadores.put("reverso", null);
                }
                if (anverso instanceof List) {
                    indicadores.put("anverso", null);
                }
                biometricObject.put("indicadores", indicadores);
            }
        }
        return biometricObject;
    }

    private static Map<String, Object> constructErrorMessageMap(Object error, Object mapmessages) {
        String validatedError = Utils.validarErrorPoint((Object)error);
        if (validatedError != null) {
            if (mapmessages == null) {
                HashMap<String, Object> msgs = new HashMap<String, Object>();
                msgs.put("error", validatedError);
                return msgs;
            }
            if (mapmessages instanceof Map) {
                try {
                    Map msgs = (Map)mapmessages;
                    if (msgs.get("error") == null) {
                        msgs.put("error", validatedError);
                    } else {
                        String errmsg = msgs.get("error").toString();
                        msgs.put("error", errmsg + " | " + validatedError);
                    }
                    return msgs;
                }
                catch (Exception e) {
                    log.warn("NO SE PUDO CASTEAR EL MAPA DE MENSAJES");
                }
            }
        }
        return null;
    }

    private static Map<String, Object> validateMessageStringList(Object messages) {
        if (messages != null) {
            log.info("messages exits");
            if (messages instanceof List && ((List)messages).isEmpty()) {
                log.info("list");
            }
            if (messages instanceof List) {
                log.info("list 2");
                HashMap<String, Object> messagesMap = new HashMap<String, Object>();
                try {
                    List data = (List)messages;
                    Object dataMap = "";
                    int i = 0;
                    while (i < data.size()) {
                        String msg = (String)data.get(i);
                        dataMap = i == data.size() - 1 ? (String)dataMap + msg : (String)dataMap + msg + " | ";
                        ++i;
                    }
                    messagesMap.put("data", dataMap);
                    return messagesMap;
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (messages instanceof Map) {
                log.info("map");
                try {
                    Map messagesMap = (Map)messages;
                    return messagesMap;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static String validarErrorPoint(Object error) {
        block4: {
            try {
                if (!(error instanceof Integer)) break block4;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (error instanceof String) {
            return String.valueOf(error);
        }
        return null;
    }

    public static String generarNombreSegmentado(String nombreOriginal, int secuencia) {
        return "seg_" + secuencia + "_" + nombreOriginal;
    }

    public static boolean isPrincipalDocument(String input) {
        if (input == null) {
            return true;
        }
        String regex = "seg_\\d+_[a-zA-Z0-9]+_[a-zA-Z0-9_]+";
        Pattern pattern = Pattern.compile(regex);
        return !pattern.matcher(input).matches();
    }
}

