/*
 * Decompiled with CFR 0.152.
 */
package com.firma.logic.service.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Base64;
import java.util.UUID;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PdfRepairServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfRepairServiceImpl.class);
    @Value(value="${ruta.temporal.firma.repaired}")
    private String basePathDocuments;

    public String repairPdfFromBase64(String base64Pdf) throws IOException {
        String uuidDoc = UUID.randomUUID().toString().concat("repaired_");
        byte[] decodedBytes = Base64.getDecoder().decode(base64Pdf);
        File inputFile = File.createTempFile("input", ".pdf");
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileOutputStream fos = new FileOutputStream(inputFile);){
            fos.write(decodedBytes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        File repairedFile = this.repairPdf(inputFile, uuidDoc);
        log.info("Archivo PDF reparado");
        byte[] repairedBytes = Files.readAllBytes(repairedFile.toPath());
        log.info("Archivo PDF reparado convertido a Base64");
        File fileTemp = new File(repairedFile.toPath().toString());
        if (fileTemp.exists()) {
            fileTemp.delete();
            log.info("Archivo temporal reparado eliminado");
        }
        return Base64.getEncoder().encodeToString(repairedBytes);
    }

    private File repairPdf(File inputFile, String uuidDoc) throws IOException {
        try (PDDocument document = null;){
            log.info("Reparando archivo PDF");
            document = PDDocument.load((File)inputFile);
            if (document.isEncrypted()) {
                document.setAllSecurityToBeRemoved(true);
            }
            File repairedFile = new File(uuidDoc + inputFile.getName());
            document.save(repairedFile);
            log.info("Archivo PDF reparado guardado en " + repairedFile.getAbsolutePath());
            File file = repairedFile;
            return file;
        }
    }
}

