/*
 * Decompiled with CFR 0.152.
 */
package com.firma.logic.service.impl;

import com.firma.logic.service.MergeSplitDocumentosService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MergeSplitDocumentosServiceImpl
implements MergeSplitDocumentosService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MergeSplitDocumentosServiceImpl.class);

    public void splitPDF(String inputFilePath, List<int[]> pageRanges, String outputFolderPath) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PDDocument document = PDDocument.load((File)new File(inputFilePath));){
                if (document.getNumberOfPages() == 0) {
                    throw new IllegalArgumentException("El documento no contiene p\u00e1ginas.");
                }
                int i = 0;
                while (i < pageRanges.size()) {
                    int[] range = pageRanges.get(i);
                    int startPage = range[0];
                    int endPage = range[1];
                    if (startPage < 1 || endPage > document.getNumberOfPages() || startPage > endPage) {
                        throw new IllegalArgumentException("Rango de p\u00e1ginas no v\u00e1lido: " + startPage + "-" + endPage);
                    }
                    PDDocument splitDocument = new PDDocument();
                    int page = startPage;
                    while (page <= endPage) {
                        splitDocument.addPage(document.getPage(page - 1));
                        ++page;
                    }
                    String outputFilePath = String.format("%s/split_part_%d.pdf", outputFolderPath, i + 1);
                    splitDocument.save(outputFilePath);
                    splitDocument.close();
                    System.out.println("Documento creado: " + outputFilePath);
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Error al procesar el archivo PDF: " + e.getMessage());
        }
    }

    public String mergePDFs(List<MultipartFile> files) {
        String outputFilePath = "path/to/merged_output.pdf";
        PDFMergerUtility merger = new PDFMergerUtility();
        try {
            for (MultipartFile file : files) {
                File tempFile = File.createTempFile("pdfmerge-", ".pdf");
                file.transferTo(tempFile);
                merger.addSource(tempFile);
            }
            merger.setDestinationFileName(outputFilePath);
            merger.mergeDocuments(null);
            return "Archivos combinados en: " + outputFilePath;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error al unir documentos: " + e.getMessage();
        }
    }
}

