/*
 * Decompiled with CFR 0.152.
 */
package com.firma.logic.service.impl;

import com.firma.exceptions.CustomException;
import com.firma.logic.model.CertificateModel;
import com.firma.logic.model.Stamp;
import com.firma.logic.service.FirmaService;
import com.firma.utils.ApiResponse;
import com.firma.utils.CertificateDataExtractor;
import com.firma.utils.SignatureUtils;
import com.firma.utils.Utils;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.signatures.PdfPKCS7;
import com.itextpdf.signatures.SignatureUtil;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;
import lombok.Generated;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class FirmaServiceImpl
implements FirmaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FirmaServiceImpl.class);
    @Value(value="${ruta.temporal.firma}")
    private String tempPathSaveDoc;

    @PostConstruct
    public void init() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private List<Stamp> extractCoordenadasFromString(String coordenadas, String nombreFirmante, LocalDateTime fecha) {
        try {
            String[] coordenadasArray = coordenadas.split(";");
            ArrayList<Stamp> listCoordenadas = new ArrayList<Stamp>();
            String[] stringArray = coordenadasArray;
            int n = coordenadasArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String[] coordenada = string.split("&");
                if (coordenada.length != 3) {
                    throw new CustomException("Las coordenadas ingresadas no son v\u00e1lidas", HttpStatus.BAD_REQUEST);
                }
                int pageNumber = Integer.parseInt(coordenada[0]) - 1;
                if (pageNumber < 0) {
                    throw new CustomException("El n\u00famero de p\u00e1gina no puede ser menor a 1", HttpStatus.BAD_REQUEST);
                }
                float x = Float.parseFloat(coordenada[1]);
                float y = Float.parseFloat(coordenada[2]);
                listCoordenadas.add(new Stamp(nombreFirmante, fecha, pageNumber, x, y));
                ++n2;
            }
            return listCoordenadas;
        }
        catch (CustomException e) {
            log.error("ERROR AL EXTRAER COORDENADAS CUSTOM EXCEPTION: " + e.getMessage());
            throw new CustomException(e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            log.error("ERROR AL EXTRAER COORDENADAS: " + e.getMessage());
            throw new CustomException("Las coordenadas ingresadas no son v\u00e1lidas", HttpStatus.BAD_REQUEST);
        }
    }

    private List<Stamp> extractCoordenadasFromString(String coordenadas, String nombreFirmante, Calendar fecha) {
        try {
            String[] coordenadasArray = coordenadas.split(";");
            ArrayList<Stamp> listCoordenadas = new ArrayList<Stamp>();
            String[] stringArray = coordenadasArray;
            int n = coordenadasArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String[] coordenada = string.split("&");
                if (coordenada.length != 3) {
                    throw new CustomException("Las coordenadas ingresadas no son v\u00e1lidas", HttpStatus.BAD_REQUEST);
                }
                int pageNumber = Integer.parseInt(coordenada[0]) - 1;
                if (pageNumber < 0) {
                    throw new CustomException("El n\u00famero de p\u00e1gina no puede ser menor a 1", HttpStatus.BAD_REQUEST);
                }
                float x = Float.parseFloat(coordenada[1]);
                float y = Float.parseFloat(coordenada[2]);
                listCoordenadas.add(new Stamp(nombreFirmante, null, pageNumber, x, y));
                ++n2;
            }
            return listCoordenadas;
        }
        catch (CustomException e) {
            log.error("ERROR AL EXTRAER COORDENADAS CUSTOM EXCEPTION: " + e.getMessage());
            throw new CustomException(e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            log.error("ERROR AL EXTRAER COORDENADAS: " + e.getMessage());
            throw new CustomException("Las coordenadas ingresadas no son v\u00e1lidas", HttpStatus.BAD_REQUEST);
        }
    }

    public ResponseEntity<?> restampSign(String base64, String identificacion, String coordenadas) {
        if (!Utils.isPdfFile((String)base64).booleanValue()) {
            throw new CustomException("El archivo enviado no corresponde a un PDF.", HttpStatus.BAD_REQUEST);
        }
        byte[] decodedFile = Base64.getDecoder().decode(base64);
        ByteArrayInputStream source = new ByteArrayInputStream(decodedFile);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (PdfReader reader = new PdfReader((InputStream)source);){
                PdfDocument pdfDoc = new PdfDocument(reader);
                SignatureUtil signUtil = new SignatureUtil(pdfDoc);
                List signatures = signUtil.getSignatureNames();
                if (signatures.isEmpty()) {
                    pdfDoc.close();
                    return new ResponseEntity((Object)ApiResponse.ok((Object)"No se encontraron firmas en el documento", (boolean)false), (HttpStatusCode)HttpStatus.OK);
                }
                for (String signatureName : signatures) {
                    PdfPKCS7 pkcs7 = signUtil.readSignatureData(signatureName);
                    boolean isSignatureCoversWholeDocument = signUtil.signatureCoversWholeDocument(signatureName);
                    log.info("Signature: " + signatureName + " covers whole document: " + isSignatureCoversWholeDocument);
                    CertificateDataExtractor extractor = new CertificateDataExtractor();
                    CertificateModel certificateModel = extractor.extractCertificateDetails(pkcs7.getSigningCertificate(), identificacion);
                    Calendar signingTime = pkcs7.getSignDate();
                    if (certificateModel == null || certificateModel.getSerialNumber() == null) continue;
                    pdfDoc.close();
                    if (certificateModel.getSerialNumber().equals(identificacion)) {
                        String nameSign = certificateModel.getSubject().getFullName();
                        List stamps = this.extractCoordenadasFromString(coordenadas, nameSign, signingTime);
                        String fileBase64 = SignatureUtils.createPdfWithMultipleStamps((List)stamps, (String)base64, (String)this.tempPathSaveDoc);
                        return new ResponseEntity((Object)ApiResponse.ok((Object)fileBase64, (boolean)true), (HttpStatusCode)HttpStatus.OK);
                    }
                    return new ResponseEntity((Object)ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"No se encontr\u00f3 una firma para la identificaci\u00f3n ingresada"), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
                pdfDoc.close();
                throw new CustomException("No se encontr\u00f3 una firma para la identificaci\u00f3n ingresada", HttpStatus.BAD_REQUEST);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error("ERROR AL VALIDAR LA FIRMA: ", (Throwable)e);
            return new ResponseEntity((Object)ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"Ha ocurrido un error al validar la firma"), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public String restampSignJust(String base64, String coordenadas, String nameSigner) {
        try {
            List stamps = this.extractCoordenadasFromString(coordenadas, nameSigner, LocalDateTime.now());
            String fileBase64 = SignatureUtils.createPdfWithMultipleStamps((List)stamps, (String)base64, (String)this.tempPathSaveDoc);
            return fileBase64;
        }
        catch (CustomException e) {
            throw new CustomException(e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            throw new CustomException("Ocurri\u00f3 un error al realizar el estampado en el documento enviado.", HttpStatus.BAD_REQUEST);
        }
    }

    public String convertDataToStamp(String documentos, String fullName, String coordenadasStampado) {
        return null;
    }
}

