/*
 * Decompiled with CFR 0.152.
 */
package com.firma.logic.service.impl;

import com.firma.logic.data.ResponseTokenUanataca;
import com.firma.logic.entity.TAuth;
import com.firma.logic.entity.biometria.TAnverso;
import com.firma.logic.entity.biometria.TCallbackBiometria;
import com.firma.logic.entity.biometria.TDataBiometria;
import com.firma.logic.entity.biometria.TIndicadores;
import com.firma.logic.entity.biometria.TMetadata;
import com.firma.logic.entity.biometria.TProcesada;
import com.firma.logic.entity.biometria.TReferencia;
import com.firma.logic.entity.biometria.TReverso;
import com.firma.logic.entity.firma.TCallbackFirma;
import com.firma.logic.repository.AuthDao;
import com.firma.logic.repository.CallbackBiometriaDAO;
import com.firma.logic.repository.CallbackFirmaDAO;
import com.firma.logic.repository.SolicitudDAO;
import com.firma.logic.service.AutenticationService;
import com.firma.logic.service.DataBaseService;
import ec.tws2.crypto.run.CryptoMain;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataBaseServiceImpl
implements DataBaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataBaseServiceImpl.class);
    private final AuthDao authDao;
    private final SolicitudDAO solicitudDAO;
    private final CryptoMain cryptoService;
    private final AutenticationService autenticationService;
    private final CallbackBiometriaDAO biometriaDAO;
    private final CallbackFirmaDAO callbackFirmaDAO;

    public String saveTokenResponse(ResponseTokenUanataca tokenResponse, String tokenKeycloak) {
        log.info("GUARDANDO EL TOKEN ENCRIPTADO");
        String jti = this.autenticationService.extractJtiFromToken(tokenKeycloak);
        String tokenUT = tokenResponse.getData().getTkn_token();
        TAuth auth = new TAuth(jti, this.cryptoService.encriptar(tokenUT));
        this.authDao.save((Object)auth);
        return tokenKeycloak;
    }

    public String getTokenFromJti() {
        String jti = this.autenticationService.getMyParameter("jti");
        String token = this.authDao.findTokenByJti(jti);
        return token;
    }

    public void guardarCallbackBiometria(TCallbackBiometria callbackBiometria) {
        try {
            if (callbackBiometria.getIndicadores() != null && callbackBiometria.getData() != null) {
                TReverso reverso;
                TIndicadores indicadores = callbackBiometria.getIndicadores();
                TDataBiometria dataBiometria = callbackBiometria.getData();
                dataBiometria.setImg_frontal(this.cryptoService.encriptar(dataBiometria.getImg_frontal()));
                dataBiometria.setImg_reverso(this.cryptoService.encriptar(dataBiometria.getImg_reverso()));
                TAnverso anverso = indicadores.getAnverso();
                if (anverso != null) {
                    anverso.setIdentificacion(this.cryptoService.encriptar(anverso.getIdentificacion()));
                    anverso.setMetadata(this.cryptoService.encriptar(anverso.getMetadata()));
                }
                if ((reverso = indicadores.getReverso()) != null) {
                    reverso.setMetadata(this.cryptoService.encriptar(reverso.getMetadata()));
                    reverso.setCodigoDactilar(this.cryptoService.encriptar(reverso.getCodigoDactilar()));
                    reverso.setCodigoDactilarEncontrado(this.cryptoService.encriptar(reverso.getCodigoDactilarEncontrado()));
                }
                TMetadata metadata = indicadores.getMetadata();
                TProcesada procesada = metadata.getProcesada();
                procesada.setCodigo_dactilar(this.cryptoService.encriptar(procesada.getCodigo_dactilar()));
                procesada.setIdentificacion(this.cryptoService.encriptar(procesada.getIdentificacion()));
                procesada.setNombre_completo(this.cryptoService.encriptar(procesada.getNombre_completo()));
                procesada.setLugar_nacimiento(this.cryptoService.encriptar(procesada.getLugar_nacimiento()));
                TReferencia referencia = metadata.getReferencia();
                referencia.setCodigo_dactilar(this.cryptoService.encriptar(referencia.getCodigo_dactilar()));
                referencia.setIdentificacion(this.cryptoService.encriptar(referencia.getIdentificacion()));
                metadata.setProcesada(procesada);
                metadata.setReferencia(referencia);
                indicadores.setMetadata(metadata);
                indicadores.setAnverso(anverso);
                indicadores.setReverso(reverso);
                callbackBiometria.setIndicadores(indicadores);
                callbackBiometria.setData(dataBiometria);
            }
            this.biometriaDAO.save((Object)callbackBiometria);
        }
        catch (Exception e) {
            log.error("ERROR AL GUARDAR LA RESPUESTA DE: " + callbackBiometria.getCodigo(), (Throwable)e);
        }
    }

    public void guardarCallbackFirma(TCallbackFirma callbackFirma) {
        try {
            this.callbackFirmaDAO.save((Object)callbackFirma);
        }
        catch (Exception e) {
            log.error("ERROR AL GUARDAR LA RESPUESTA DE: " + callbackFirma.getCodigo(), (Throwable)e);
        }
    }

    public String getOriginalCallbackFromProcessCode(String code, String tipo) {
        return this.solicitudDAO.getOriginalCallbackFromTransactionCode(code, tipo);
    }

    @Generated
    public DataBaseServiceImpl(AuthDao authDao, SolicitudDAO solicitudDAO, CryptoMain cryptoService, AutenticationService autenticationService, CallbackBiometriaDAO biometriaDAO, CallbackFirmaDAO callbackFirmaDAO) {
        this.authDao = authDao;
        this.solicitudDAO = solicitudDAO;
        this.cryptoService = cryptoService;
        this.autenticationService = autenticationService;
        this.biometriaDAO = biometriaDAO;
        this.callbackFirmaDAO = callbackFirmaDAO;
    }
}

