/*
 * Decompiled with CFR 0.152.
 */
package com.firma.logic.restTemplate;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.firma.logic.data.ResponseBiometriaUanataca;
import com.firma.logic.data.ResponseFirmaUanataca;
import com.firma.logic.data.ResponseTokenUanataca;
import com.firma.logic.entity.biometria.TCallbackBiometria;
import com.firma.logic.entity.firma.TCallbackFirma;
import com.firma.logic.restTemplate.service.UanatacaServiceAPI;
import java.util.Base64;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class UanatacaServiceAPIImpl
implements UanatacaServiceAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UanatacaServiceAPIImpl.class);
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final Environment env;

    public ResponseTokenUanataca getTokenUanataca(String username, String password, String pin) {
        try {
            String urlToken = this.env.getProperty("uanataca.url.token");
            log.info("Calling token");
            String auth = username + ":" + password;
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Basic " + encodedAuth);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("pin", pin);
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)urlToken).queryParam("pin", new Object[]{pin});
            HttpEntity entity = new HttpEntity(params, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(builder.toUriString(), HttpMethod.POST, entity, ResponseTokenUanataca.class, new Object[0]);
            return (ResponseTokenUanataca)response.getBody();
        }
        catch (HttpClientErrorException e) {
            log.error("Error ", (Throwable)e);
            log.info("Error response uanataca: " + e.getResponseBodyAsString());
            try {
                ResponseTokenUanataca result = (ResponseTokenUanataca)this.objectMapper.readValue(e.getResponseBodyAsString(), ResponseTokenUanataca.class);
                log.info("response uanataca error: " + String.valueOf(result));
                return result;
            }
            catch (Exception ex) {
                HashMap<String, String> messages = new HashMap<String, String>();
                messages.put("error", "Error al obtener el token");
                return new ResponseTokenUanataca(500, "500", messages, null);
            }
        }
        catch (Exception e) {
            log.error("Error EX: ", (Throwable)e);
            return null;
        }
    }

    public ResponseBiometriaUanataca getBiometriaUanataca(String identificacion, String callback, String codigoInterno, String motivo, String token) {
        String urlBiometria = this.env.getProperty("uanataca.url.biometria");
        try {
            log.info("Calling biometria");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            headers.setBearerAuth(token);
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.add((Object)"identificacion", (Object)identificacion);
            params.add((Object)"callback", (Object)callback);
            params.add((Object)"codigo_interno", (Object)codigoInterno);
            params.add((Object)"motivo", (Object)motivo);
            HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(urlBiometria, HttpMethod.POST, requestEntity, ResponseBiometriaUanataca.class, new Object[0]);
            return (ResponseBiometriaUanataca)response.getBody();
        }
        catch (HttpClientErrorException e) {
            log.error("Error ", (Throwable)e);
            log.info("Error response uanataca: " + e.getResponseBodyAsString());
            try {
                ResponseBiometriaUanataca result = (ResponseBiometriaUanataca)this.objectMapper.readValue(e.getResponseBodyAsString(), ResponseBiometriaUanataca.class);
                log.info("response uanataca error: " + String.valueOf(result));
                return result;
            }
            catch (Exception ex) {
                HashMap<String, String> messages = new HashMap<String, String>();
                messages.put("error", "Error al cosumir la biometria");
                return new ResponseBiometriaUanataca(500, "500", messages, null);
            }
        }
        catch (Exception e) {
            log.error("Error EX: ", (Throwable)e);
            return null;
        }
    }

    public ResponseFirmaUanataca getFirmaUanataca(String codigoBiometrico, String codigoCliente, String identificacion, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String documentos, String callback, String token) {
        String urlBiometria = this.env.getProperty("uanataca.url.firma");
        try {
            log.info("Calling biometria");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            headers.setBearerAuth(token);
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.add((Object)"codigoBiometrico", (Object)codigoBiometrico);
            params.add((Object)"codigoCliente", (Object)codigoCliente);
            params.add((Object)"identificacion", (Object)identificacion);
            params.add((Object)"nombres", (Object)nombres);
            params.add((Object)"apellido_paterno", (Object)apellidoPaterno);
            params.add((Object)"apellido_materno", (Object)apellidoMaterno);
            params.add((Object)"email", (Object)email);
            params.add((Object)"celular", (Object)celular);
            params.add((Object)"domicilio", (Object)domicilio);
            params.add((Object)"ciudad", (Object)ciudad);
            params.add((Object)"documentos", (Object)documentos);
            params.add((Object)"callback", (Object)callback);
            HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(urlBiometria, HttpMethod.POST, requestEntity, ResponseFirmaUanataca.class, new Object[0]);
            log.info("response uanataca: " + String.valueOf(response));
            return (ResponseFirmaUanataca)response.getBody();
        }
        catch (HttpClientErrorException e) {
            log.error("Error en firmas", (Throwable)e);
            log.info("Error response uanataca: " + e.getResponseBodyAsString());
            try {
                ResponseFirmaUanataca result = (ResponseFirmaUanataca)this.objectMapper.readValue(e.getResponseBodyAsString(), ResponseFirmaUanataca.class);
                log.info("response uanataca error: " + String.valueOf(result));
                return result;
            }
            catch (Exception ex) {
                HashMap<String, String> messages = new HashMap<String, String>();
                messages.put("error", "Error al cosumir la biometria");
                return new ResponseFirmaUanataca(Integer.valueOf(500), "500", messages, null);
            }
        }
        catch (Exception e) {
            log.error("Error no identificado al solicitar la firma: ", (Throwable)e);
            return null;
        }
    }

    public String postReturningCallbackBiometria(TCallbackBiometria callback, String urlCallback) {
        try {
            log.info("Calling biometria");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity((Object)callback, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(urlCallback, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            return (String)response.getBody();
        }
        catch (HttpClientErrorException e) {
            log.error("Error ", (Throwable)e);
            log.info("Error response uanataca: " + e.getResponseBodyAsString());
            return e.getResponseBodyAsString();
        }
        catch (Exception e) {
            log.error("Error EX: ", (Throwable)e);
            return null;
        }
    }

    public String postReturningCallbackFirma(TCallbackFirma callback, String urlCallback) {
        try {
            log.info("Calling biometria");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity((Object)callback, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(urlCallback, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            return (String)response.getBody();
        }
        catch (HttpClientErrorException e) {
            log.error("Error ", (Throwable)e);
            log.info("Error response uanataca: " + e.getResponseBodyAsString());
            return e.getResponseBodyAsString();
        }
        catch (Exception e) {
            log.error("Error EX: ", (Throwable)e);
            return null;
        }
    }

    @Generated
    public UanatacaServiceAPIImpl(RestTemplate restTemplate, ObjectMapper objectMapper, Environment env) {
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.env = env;
    }
}

