/*
 * Decompiled with CFR 0.152.
 */
package com.firma.logic.controller;

import com.firma.exceptions.CustomException;
import com.firma.logic.service.UanatacaService;
import com.firma.utils.ConvertJsonService;
import com.firma.utils.ValidationUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UanatacaController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UanatacaController.class);
    private final UanatacaService uanatacaService;
    private final ConvertJsonService convertJsonService;

    @PostMapping(value={"/v3/solicitud/biometrico"})
    public ResponseEntity<?> callbiometria(@RequestParam(value="identificacion", required=false) String identificacion, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="codigo_interno", required=false) String codigoInterno, @RequestParam(value="motivo", required=false) String motivo, @RequestParam(value="origen", required=false) String origen, @RequestParam(value="canal", required=false) String canal) {
        ValidationUtils.validarParamsBiometria((String)codigoInterno, (String)identificacion, (String)callback, (String)origen, (String)canal);
        return this.uanatacaService.solicitarBiometria(identificacion, callback, codigoInterno, motivo, origen, canal);
    }

    @PostMapping(value={"v1/solicitud/firma"})
    public ResponseEntity<?> callFirma(@RequestParam(value="codigoBiometrico", required=false) String codigoBiometrico, @RequestParam(value="codigoCliente", required=false) String codigoCliente, @RequestParam(value="identificacion", required=false) String identificacion, @RequestParam(value="nombres", required=false) String nombres, @RequestParam(value="apellido_paterno", required=false) String apellidoPaterno, @RequestParam(value="apellido_materno", required=false) String apellidoMaterno, @RequestParam(value="email", required=false) String email, @RequestParam(value="celular", required=false) String celular, @RequestParam(value="domicilio", required=false) String domicilio, @RequestParam(value="ciudad", required=false) String ciudad, @RequestParam(value="documentos", required=false) String documentos, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="origen", required=false) String origen, @RequestParam(value="canal", required=false) String canal) {
        ValidationUtils.validarParamsFirma((String)codigoBiometrico, (String)codigoCliente, (String)identificacion, (String)nombres, (String)apellidoPaterno, (String)apellidoMaterno, (String)email, (String)celular, (String)domicilio, (String)ciudad, (String)documentos, (String)callback, (String)origen, (String)canal);
        String fullSignerName = nombres + " " + apellidoPaterno + " " + apellidoMaterno;
        String stampedDocs = this.convertJsonService.transformStringToListDocumentModel(documentos, fullSignerName);
        return this.uanatacaService.solicitarFirma(codigoBiometrico, codigoCliente, identificacion, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, stampedDocs, origen, callback, canal);
    }

    @PostMapping(value={"v1/solicitud/firma/segmentado"})
    public Object postMethodName(@RequestParam(value="codigoBiometrico", required=false) String codigoBiometrico, @RequestParam(value="codigoCliente", required=false) String codigoCliente, @RequestParam(value="identificacion", required=false) String identificacion, @RequestParam(value="nombres", required=false) String nombres, @RequestParam(value="apellido_paterno", required=false) String apellidoPaterno, @RequestParam(value="apellido_materno", required=false) String apellidoMaterno, @RequestParam(value="email", required=false) String email, @RequestParam(value="celular", required=false) String celular, @RequestParam(value="domicilio", required=false) String domicilio, @RequestParam(value="ciudad", required=false) String ciudad, @RequestParam(value="documentos", required=false) String documentos, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="origen", required=false) String origen, @RequestParam(value="canal", required=false) String canal) throws CustomException {
        ValidationUtils.validarParamsFirma((String)codigoBiometrico, (String)codigoCliente, (String)identificacion, (String)nombres, (String)apellidoPaterno, (String)apellidoMaterno, (String)email, (String)celular, (String)domicilio, (String)ciudad, (String)documentos, (String)callback, (String)origen, (String)canal);
        String fullSignerName = nombres + " " + apellidoPaterno + " " + apellidoMaterno;
        String documentsValidated = this.uanatacaService.validarDocumentoSegmentadosTransformadosString(documentos, fullSignerName);
        log.info("LOS DOCUMENTOS FUERON VALIDADOS CORRECTAMENTE SE PROCEDE A SOLICITAR LA FIRMA");
        return this.uanatacaService.solicitarFirma(codigoBiometrico, codigoCliente, identificacion, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, documentsValidated, origen, callback, canal);
    }

    @Generated
    public UanatacaController(UanatacaService uanatacaService, ConvertJsonService convertJsonService) {
        this.uanatacaService = uanatacaService;
        this.convertJsonService = convertJsonService;
    }
}

