/*
 * Decompiled with CFR 0.152.
 */
package com.firma.auth;

import com.firma.auth.JwtAuthConverter;
import com.firma.interceptors.CustomAccessDeniedHandler;
import com.firma.interceptors.CustomAuthenticationEntryPoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig {
    private final JwtAuthConverter jwtAuthConverter;
    private final CustomAuthenticationEntryPoint customAuthenticationEntryPoint;
    private final CustomAccessDeniedHandler customAccessDeniedHandler;

    public WebSecurityConfig(JwtAuthConverter jwtAuthConverter, CustomAuthenticationEntryPoint customAuthenticationEntryPoint, CustomAccessDeniedHandler customAccessDeniedHandler) {
        this.jwtAuthConverter = jwtAuthConverter;
        this.customAuthenticationEntryPoint = customAuthenticationEntryPoint;
        this.customAccessDeniedHandler = customAccessDeniedHandler;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.exceptionHandling(exceptionHandling -> {
            ExceptionHandlingConfigurer exceptionHandlingConfigurer = exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)this.customAuthenticationEntryPoint).accessDeniedHandler((AccessDeniedHandler)this.customAccessDeniedHandler);
        }).authorizeHttpRequests(authorize -> {
            AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/v1/token"})).permitAll().requestMatchers(new String[]{"/notifications/movil"})).permitAll().requestMatchers(new String[]{"/notifications/**"})).permitAll().requestMatchers(new String[]{"/notifications"})).permitAll().requestMatchers(new String[]{"/callback/biometria"})).permitAll().requestMatchers(new String[]{"/callback/firma"})).permitAll().requestMatchers(new String[]{"/reporte-biometria/**"})).permitAll().anyRequest()).authenticated();
        }).oauth2ResourceServer(oauth2 -> {
            OAuth2ResourceServerConfigurer oAuth2ResourceServerConfigurer = oauth2.jwt(jwt -> {
                OAuth2ResourceServerConfigurer.JwtConfigurer jwtConfigurer = jwt.jwtAuthenticationConverter((Converter)this.jwtAuthConverter);
            }).authenticationEntryPoint((AuthenticationEntryPoint)this.customAuthenticationEntryPoint).accessDeniedHandler((AccessDeniedHandler)this.customAccessDeniedHandler);
        }).sessionManagement(session -> {
            SessionManagementConfigurer sessionManagementConfigurer = session.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        }).csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }
}

