/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.utils;

import com.eabrokers.exceptions.CustomException;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static boolean isValidBase64(String base64String) {
        if (base64String == null || base64String.isEmpty()) {
            return false;
        }
        try {
            Base64.getDecoder().decode(base64String);
            return true;
        }
        catch (IllegalArgumentException e) {
            log.warn("not a valid base64");
            return false;
        }
    }

    public static String limpiarCamposSoloLetras(String valor) {
        valor = valor.replace(" ", "_");
        valor = valor.replaceAll("[^0-9a-zA-Z_]", "");
        return valor.toUpperCase();
    }

    public static Boolean isPdfFile(String base64String) {
        byte[] data = Base64.getDecoder().decode(base64String);
        String headerStr = new String(data, 0, 5);
        return headerStr.equals("%PDF-");
    }

    public static int getPageNumber(byte[] pdfContent) {
        try {
            PdfReader reader = new PdfReader((InputStream)new ByteArrayInputStream(pdfContent));
            PdfDocument document = new PdfDocument(reader);
            int numberOfPages = document.getNumberOfPages();
            document.close();
            reader.close();
            return numberOfPages;
        }
        catch (Exception e) {
            throw new CustomException("No se ha podido identificar la p\u00e1gina a firmar", HttpStatus.BAD_REQUEST);
        }
    }

    public static Map validateBiometricObject(Map<String, Object> biometricObject) {
        log.info("validate json");
        Object tipo = biometricObject.get("tipo");
        Object error = biometricObject.get("error");
        if (tipo == null) {
            return biometricObject;
        }
        if (tipo.equals("PRUEBA_VIDA")) {
            Map concatErrMessage;
            Map indicadores = (Map)biometricObject.get("indicadores");
            Object messages = biometricObject.get("messages");
            Map validatedMessage = Utils.validateMessageStringList((Object)messages);
            if (validatedMessage != null) {
                biometricObject.put("messages", validatedMessage);
            }
            if ((concatErrMessage = Utils.constructErrorMessageMap((Object)error, (Object)biometricObject.get("messages"))) != null) {
                biometricObject.put("messages", concatErrMessage);
            }
            if (indicadores != null) {
                Object reverso = indicadores.get("reverso");
                Object anverso = indicadores.get("anverso");
                if (reverso instanceof List) {
                    indicadores.put("reverso", null);
                }
                if (anverso instanceof List) {
                    indicadores.put("anverso", null);
                }
                biometricObject.put("indicadores", indicadores);
            }
        }
        return biometricObject;
    }

    private static Map<String, Object> constructErrorMessageMap(Object error, Object mapmessages) {
        String validatedError = Utils.validarErrorPoint((Object)error);
        if (validatedError != null) {
            if (mapmessages == null) {
                HashMap<String, Object> msgs = new HashMap<String, Object>();
                msgs.put("error", validatedError);
                return msgs;
            }
            if (mapmessages instanceof Map) {
                try {
                    Map msgs = (Map)mapmessages;
                    if (msgs.get("error") == null) {
                        msgs.put("error", validatedError);
                    } else {
                        String errmsg = msgs.get("error").toString();
                        msgs.put("error", errmsg + " | " + validatedError);
                    }
                    return msgs;
                }
                catch (Exception e) {
                    log.warn("NO SE PUDO CASTEAR EL MAPA DE MENSAJES");
                }
            }
        }
        return null;
    }

    private static Map<String, Object> validateMessageStringList(Object messages) {
        if (messages != null) {
            log.info("messages exits");
            if (messages instanceof List && ((List)messages).isEmpty()) {
                log.info("list");
            }
            if (messages instanceof List) {
                log.info("list 2");
                HashMap<String, Object> messagesMap = new HashMap<String, Object>();
                try {
                    List data = (List)messages;
                    Object dataMap = "";
                    for (int i = 0; i < data.size(); ++i) {
                        String msg = (String)data.get(i);
                        dataMap = i == data.size() - 1 ? (String)dataMap + msg : (String)dataMap + msg + " | ";
                    }
                    messagesMap.put("data", dataMap);
                    return messagesMap;
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (messages instanceof Map) {
                log.info("map");
                try {
                    Map messagesMap = (Map)messages;
                    return messagesMap;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static String validarErrorPoint(Object error) {
        try {
            if (error instanceof Integer) {
                return null;
            }
            if (error instanceof String) {
                return String.valueOf(error);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

