/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.utils;

import com.eabrokers.logic.dto.ClientDTO;
import com.eabrokers.logic.dto.InvoiceFakeDTO;
import com.eabrokers.logic.entity.insurance.TInsuredPerson;
import com.eabrokers.utils.FileUtil;
import com.eabrokers.utils.ImageUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.Barcode128;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;

/*
 * Exception performing whole class analysis ignored.
 */
public class PdfBillUtil {
    private static final String COMPANY_LEGAL_NAME = "Technology as a service";
    private static final String COMPANY_ADDRESS = "Dir Matriz: Av. Isabela Cat\u00f3lica y Francisco de Orellana Edif. Madrigal oficina 102, Cuenca, Azuay 010107, Ecuador";
    private static final String COMPANY_SPECIAL_CONTRIBUTOR = "Contribuyente Especial N\u00b0: No Aplica";
    private static final String COMPANY_ACCOUNTING = "OBLIGADO A LLEVAR CONTABILIDAD: SI";
    private static final String INVOICE_NUMBER = "001-011-07105606";
    private static final String AUTHORIZATION_NUMBER = "01202001077784491031001107102100718625733";
    private static final String ENVIRONMENT = "PRUEBAS";
    private static final String EMISSION_TYPE = "NORMAL";
    private static final String ACCESS_KEY = "01202001077784491031001107102100718625733";

    public static String generateInvoiceEcuadorStyle(TInsuredPerson person, InvoiceFakeDTO invoice) {
        ClientDTO client = new ClientDTO(person.getFullName(), person.getIdentification(), PdfBillUtil.getCurrentFormattedDate());
        return FileUtil.convertToBase64String((byte[])PdfBillUtil.generateInvoiceStyle((ClientDTO)client, (InvoiceFakeDTO)invoice));
    }

    public static byte[] generateInvoiceStyle(ClientDTO client, InvoiceFakeDTO invoice) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Document document = new Document(PageSize.A4, 25.0f, 25.0f, 15.0f, 15.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            Font bold14 = new Font(Font.FontFamily.HELVETICA, 14.0f, 1);
            Font bold12 = new Font(Font.FontFamily.HELVETICA, 12.0f, 1);
            Font normal10 = new Font(Font.FontFamily.HELVETICA, 10.0f);
            Font bold10 = new Font(Font.FontFamily.HELVETICA, 10.0f, 1);
            Font small8 = new Font(Font.FontFamily.HELVETICA, 8.0f);
            byte[] imageBytes = Base64.getDecoder().decode(ImageUtil.imageCompany());
            Image logo = Image.getInstance((byte[])imageBytes);
            logo.scaleToFit(90.0f, 90.0f);
            logo.setAlignment(1);
            PdfPTable mainTable = new PdfPTable(2);
            mainTable.setWidthPercentage(100.0f);
            mainTable.setSpacingAfter(15.0f);
            mainTable.setWidths(new float[]{1.5f, 1.5f});
            PdfPTable leftColumn = new PdfPTable(1);
            PdfPCell logoCell = new PdfPCell(logo);
            logoCell.setBorder(0);
            logoCell.setHorizontalAlignment(1);
            logoCell.setPaddingBottom(10.0f);
            leftColumn.addCell(logoCell);
            PdfPTable companyTable = new PdfPTable(1);
            companyTable.addCell(PdfBillUtil.createCell((String)"Technology as a service", (Font)bold14));
            companyTable.addCell(PdfBillUtil.createCell((String)"Dir Matriz: Av. Isabela Cat\u00f3lica y Francisco de Orellana Edif. Madrigal oficina 102, Cuenca, Azuay 010107, Ecuador", (Font)normal10));
            companyTable.addCell(PdfBillUtil.createCell((String)"Contribuyente Especial N\u00b0: No Aplica", (Font)normal10));
            companyTable.addCell(PdfBillUtil.createCell((String)"OBLIGADO A LLEVAR CONTABILIDAD: SI", (Font)normal10));
            PdfPCell companyCell = new PdfPCell(companyTable);
            companyCell.setBorder(15);
            companyCell.setBorderColor(new BaseColor(200, 200, 200));
            companyCell.setPadding(8.0f);
            leftColumn.addCell(companyCell);
            PdfPCell leftContainer = new PdfPCell(leftColumn);
            leftContainer.setBorder(0);
            mainTable.addCell(leftContainer);
            PdfPTable rightColumn = new PdfPTable(1);
            PdfPTable invoiceTable = new PdfPTable(1);
            invoiceTable.addCell(PdfBillUtil.createCell((String)"No.: 001-011-07105606", (Font)bold12));
            invoiceTable.addCell(PdfBillUtil.createCell((String)"N\u00daMERO DE AUTORIZACI\u00d3N", (Font)normal10));
            invoiceTable.addCell(PdfBillUtil.createCell((String)PdfBillUtil.formatNumber((String)"01202001077784491031001107102100718625733"), (Font)small8));
            invoiceTable.addCell(PdfBillUtil.createCell((String)("FECHA Y HORA DE AUTORIZACI\u00d3N: " + PdfBillUtil.getCurrentFormattedDate()), (Font)normal10));
            invoiceTable.addCell(PdfBillUtil.createCell((String)"AMBIENTE: PRUEBAS", (Font)normal10));
            invoiceTable.addCell(PdfBillUtil.createCell((String)"EMISI\u00d3N: NORMAL", (Font)normal10));
            PdfPCell invoiceCell = new PdfPCell(invoiceTable);
            invoiceCell.setBorder(15);
            invoiceCell.setBorderColor(new BaseColor(200, 200, 200));
            invoiceCell.setPadding(8.0f);
            rightColumn.addCell(invoiceCell);
            PdfContentByte cb = writer.getDirectContent();
            Barcode128 barcode = new Barcode128();
            barcode.setCode("01202001077784491031001107102100718625733");
            barcode.setCodeType(9);
            barcode.setBarHeight(50.0f);
            barcode.setX(1.0f);
            barcode.setFont(null);
            Image barcodeImage = barcode.createImageWithBarcode(cb, BaseColor.BLACK, BaseColor.BLACK);
            barcodeImage.setAlignment(1);
            PdfPTable barcodeTable = new PdfPTable(1);
            barcodeTable.setWidthPercentage(100.0f);
            PdfPCell barcodeCell = new PdfPCell(barcodeImage);
            barcodeCell.setBorder(0);
            barcodeCell.setHorizontalAlignment(1);
            barcodeCell.setPaddingBottom(4.0f);
            barcodeTable.addCell(barcodeCell);
            Font monoFont = new Font(Font.FontFamily.COURIER, 10.0f, 0, BaseColor.DARK_GRAY);
            PdfPCell numberCell = new PdfPCell(new Phrase("01202001077784491031001107102100718625733", monoFont));
            numberCell.setBorder(0);
            numberCell.setHorizontalAlignment(1);
            numberCell.setPaddingTop(0.0f);
            barcodeTable.addCell(numberCell);
            PdfPCell barcodeContainer = new PdfPCell(barcodeTable);
            barcodeContainer.setBorder(0);
            rightColumn.addCell(barcodeContainer);
            PdfPCell rightContainer = new PdfPCell(rightColumn);
            rightContainer.setBorder(0);
            mainTable.addCell(rightContainer);
            document.add((Element)mainTable);
            document.add((Element)PdfBillUtil.createClientSection((Font)bold10, (Font)normal10, (ClientDTO)client));
            document.add((Element)Chunk.NEWLINE);
            document.add((Element)PdfBillUtil.createItemsTable((Font)bold10, (Font)normal10, (InvoiceFakeDTO)invoice));
            document.add((Element)Chunk.NEWLINE);
            document.add((Element)PdfBillUtil.createInfoAndTotalsSection((Font)bold10, (Font)normal10, (InvoiceFakeDTO)invoice));
            document.close();
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error al generar el PDF de la factura", e);
            }
        }
        baos.close();
        return byArray;
    }

    private static PdfPTable createClientSection(Font bold10, Font normal10, ClientDTO client) throws DocumentException {
        PdfPTable clientTable = new PdfPTable(4);
        clientTable.setWidthPercentage(100.0f);
        clientTable.setWidths(new float[]{1.5f, 2.5f, 1.5f, 2.5f});
        clientTable.setSpacingAfter(10.0f);
        clientTable.addCell(PdfBillUtil.createCell((String)"Raz\u00f3n Social / Nombres y Apellidos:", (Font)bold10));
        clientTable.addCell(PdfBillUtil.createCell((String)client.getFullName(), (Font)normal10));
        clientTable.addCell(PdfBillUtil.createCell((String)"Identificaci\u00f3n:", (Font)bold10));
        clientTable.addCell(PdfBillUtil.createCell((String)client.getIdentification(), (Font)normal10));
        clientTable.addCell(PdfBillUtil.createCell((String)"Fecha de Emisi\u00f3n:", (Font)bold10));
        clientTable.addCell(PdfBillUtil.createCell((String)client.getEmissionDate(), (Font)normal10));
        clientTable.addCell(PdfBillUtil.createCell((String)"", (Font)normal10));
        clientTable.addCell(PdfBillUtil.createCell((String)"", (Font)normal10));
        return clientTable;
    }

    private static PdfPCell createCell(String text, Font font) {
        PdfPCell cell = new PdfPCell(new Phrase(text, font));
        cell.setPadding(5.0f);
        cell.setBorderColor(new BaseColor(200, 200, 200));
        return cell;
    }

    private static PdfPCell createHeaderCell(String text) {
        Font font = new Font(Font.FontFamily.HELVETICA, 10.0f, 1, BaseColor.WHITE);
        PdfPCell cell = new PdfPCell(new Phrase(text, font));
        cell.setBackgroundColor(new BaseColor(255, 99, 71));
        cell.setHorizontalAlignment(1);
        cell.setPadding(5.0f);
        return cell;
    }

    private static String formatNumber(String number) {
        if (number.length() > 22) {
            return number.substring(0, 22) + "\n" + number.substring(22);
        }
        return number;
    }

    private static PdfPTable createItemsTable(Font bold10, Font normal10, InvoiceFakeDTO invoice) throws DocumentException {
        String[] headers;
        PdfPTable itemsTable = new PdfPTable(6);
        itemsTable.setWidthPercentage(100.0f);
        itemsTable.setWidths(new float[]{1.2f, 2.2f, 3.5f, 1.2f, 1.5f, 1.5f});
        itemsTable.setSpacingAfter(10.0f);
        for (String header : headers = new String[]{"Cod. Principal", "Cod. Auxiliar", "Descripci\u00f3n", "Cant.", "P. Unitario", "Total"}) {
            itemsTable.addCell(PdfBillUtil.createHeaderCell((String)header));
        }
        itemsTable.addCell(PdfBillUtil.createCell((String)"001", (Font)normal10));
        itemsTable.addCell(PdfBillUtil.createCell((String)"", (Font)normal10));
        itemsTable.addCell(PdfBillUtil.createCell((String)invoice.getTitle(), (Font)normal10));
        itemsTable.addCell(PdfBillUtil.createCell((String)"1", (Font)normal10));
        itemsTable.addCell(PdfBillUtil.createCell((String)("" + invoice.getUnitValue()), (Font)normal10));
        itemsTable.addCell(PdfBillUtil.createCell((String)("" + invoice.getUnitValue()), (Font)normal10));
        return itemsTable;
    }

    private static PdfPTable createInfoAndTotalsSection(Font bold10, Font normal10, InvoiceFakeDTO invoice) throws DocumentException {
        PdfPTable infoTotalTable = new PdfPTable(2);
        infoTotalTable.setWidthPercentage(100.0f);
        infoTotalTable.setWidths(new float[]{1.6f, 1.4f});
        infoTotalTable.setSpacingBefore(10.0f);
        PdfPTable infoTable = new PdfPTable(1);
        infoTable.addCell(PdfBillUtil.createCell((String)"Informaci\u00f3n Adicional", (Font)bold10));
        infoTable.addCell(PdfBillUtil.createCell((String)"Ciudad: CUENCA", (Font)normal10));
        infoTable.addCell(PdfBillUtil.createCell((String)"Direcci\u00f3n:Av. Loja y Av. Don Bosco", (Font)normal10));
        infoTable.addCell(PdfBillUtil.createCell((String)"Tel\u00e9fono: +5939999999", (Font)normal10));
        infoTable.addCell(PdfBillUtil.createCell((String)"Email: test@tws2.io", (Font)normal10));
        infoTable.addCell(PdfBillUtil.createCell((String)"Forma de Pago: TRANSFERENCIA BANCARIA", (Font)normal10));
        PdfPCell infoCell = new PdfPCell(infoTable);
        infoCell.setBorder(15);
        infoCell.setBorderColor(new BaseColor(150, 150, 150));
        infoCell.setPadding(5.0f);
        infoTotalTable.addCell(infoCell);
        PdfPTable totalsTable = new PdfPTable(2);
        totalsTable.setWidths(new float[]{3.0f, 1.0f});
        totalsTable.setWidthPercentage(100.0f);
        totalsTable.addCell(PdfBillUtil.createCell((String)"SUBTOTAL 15%", (Font)normal10));
        totalsTable.addCell(PdfBillUtil.createCell((String)("" + invoice.getUnitValue()), (Font)normal10));
        totalsTable.addCell(PdfBillUtil.createCell((String)"SUBTOTAL 0%", (Font)normal10));
        totalsTable.addCell(PdfBillUtil.createCell((String)"0.00", (Font)normal10));
        totalsTable.addCell(PdfBillUtil.createCell((String)"SUBTOTAL SIN IMPUESTOS", (Font)normal10));
        totalsTable.addCell(PdfBillUtil.createCell((String)"0.00", (Font)normal10));
        totalsTable.addCell(PdfBillUtil.createCell((String)"IVA 15%", (Font)normal10));
        totalsTable.addCell(PdfBillUtil.createCell((String)("" + invoice.getTaxValue()), (Font)normal10));
        totalsTable.addCell(PdfBillUtil.createCell((String)"PROPINA", (Font)normal10));
        totalsTable.addCell(PdfBillUtil.createCell((String)"0.00", (Font)normal10));
        PdfPCell totalLabelCell = PdfBillUtil.createCell((String)"TOTAL", (Font)bold10);
        totalLabelCell.setBackgroundColor(new BaseColor(220, 220, 220));
        totalsTable.addCell(totalLabelCell);
        PdfPCell totalValueCell = PdfBillUtil.createCell((String)("" + invoice.getTotalValue()), (Font)bold10);
        totalValueCell.setBackgroundColor(new BaseColor(220, 220, 220));
        totalsTable.addCell(totalValueCell);
        PdfPCell totalsCell = new PdfPCell(totalsTable);
        totalsCell.setBorder(15);
        totalsCell.setBorderColor(new BaseColor(150, 150, 150));
        totalsCell.setPadding(5.0f);
        infoTotalTable.addCell(totalsCell);
        return infoTotalTable;
    }

    public static String getCurrentFormattedDate() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
        LocalDateTime now = LocalDateTime.now();
        return now.format(formatter);
    }
}

