/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.utils;

import com.eabrokers.logic.entity.biometria.TCallbackBiometria;
import ec.tws2.crypto.run.CryptoMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DecriptUtils {
    private static final Logger log = LoggerFactory.getLogger(DecriptUtils.class);
    private final CryptoMain cryptoService;

    public TCallbackBiometria decryptPhotos(TCallbackBiometria biometria) {
        try {
            if (biometria != null && biometria.getData() != null) {
                String img_cedula_frontal = this.cryptoService.decrypt(biometria.getData().getImg_frontal());
                String img_cedula_reverso = this.cryptoService.decrypt(biometria.getData().getImg_reverso());
                biometria.getData().setImg_frontal(img_cedula_frontal);
                biometria.getData().setImg_reverso(img_cedula_reverso);
                return biometria;
            }
        }
        catch (Exception e) {
            log.warn("ERROR AL DECODIFICAR LA INFORMACION DE BIOMETRIA");
            return biometria;
        }
        return biometria;
    }

    public DecriptUtils(CryptoMain cryptoService) {
        this.cryptoService = cryptoService;
    }
}

