/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.utils;

import com.eabrokers.logic.model.CertificateIssuer;
import com.eabrokers.logic.model.CertificateModel;
import com.eabrokers.logic.model.CertificateSubject;
import com.eabrokers.utils.DateUtil;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CertificateDataExtractor {
    private static final Logger log = LoggerFactory.getLogger(CertificateDataExtractor.class);

    public CertificateModel extractCertificateDetails(X509Certificate cert, String identificacion) {
        log.info("Extrayendo informaci\u00f3n para el estampado del usuario con identificaci\u00f3n: , {}", (Object)identificacion);
        CertificateModel certificateModel = new CertificateModel();
        certificateModel.setIssuer(this.getIssuerDetails(cert));
        certificateModel.setSubject(this.getSubjectDetails(cert));
        String serialNumber = cert.getSerialNumber().toString(16);
        if (!serialNumber.equals(identificacion)) {
            serialNumber = this.loadValue(cert, identificacion);
        }
        certificateModel.setSerialNumber(serialNumber);
        certificateModel.setValidFrom(DateUtil.convertDateToLocalDateTime((Date)cert.getNotBefore()));
        certificateModel.setValidTo(DateUtil.convertDateToLocalDateTime((Date)cert.getNotAfter()));
        return certificateModel;
    }

    private String loadValue(X509Certificate cert, String identificacion) {
        try {
            JcaX509CertificateHolder certHolder = new JcaX509CertificateHolder(cert);
            List oids = certHolder.getExtensionOIDs();
            for (ASN1ObjectIdentifier oid : oids) {
                Extension extension = certHolder.getExtension(oid);
                if (extension == null) continue;
                ASN1Primitive asn1Primitive = ASN1Primitive.fromByteArray((byte[])extension.getExtnValue().getOctets());
                String value = asn1Primitive.toString();
                System.out.println("OID: " + oid.getId() + " Valor: " + value);
                if (!value.equals(identificacion)) continue;
                return value;
            }
        }
        catch (Exception e) {
            log.error("Error loading certificate value", (Throwable)e);
        }
        return null;
    }

    protected static Map<String, String> parseDistinguishedName(String dn) {
        String[] tokens;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String token : tokens = dn.split(",")) {
            String[] parts = token.trim().split("=");
            if (parts.length != 2) continue;
            String key = parts[0];
            String value = parts[1];
            result.put(key, value);
        }
        return result;
    }

    protected CertificateSubject getSubjectDetails(X509Certificate cert) {
        CertificateSubject subject = new CertificateSubject();
        Map subjectDetails = CertificateDataExtractor.parseDistinguishedName((String)cert.getSubjectDN().getName());
        subject.setSurName((String)subjectDetails.get("SN"));
        subject.setGivenName((String)subjectDetails.get("GN"));
        subject.setFullName((String)subjectDetails.get("CN"));
        subject.setSerialNumber((String)subjectDetails.get("SERIALNUMBER"));
        subject.setCountry((String)subjectDetails.get("C"));
        return subject;
    }

    protected CertificateIssuer getIssuerDetails(X509Certificate cert) {
        CertificateIssuer issuer = new CertificateIssuer();
        Map issuerDetails = CertificateDataExtractor.parseDistinguishedName((String)cert.getIssuerDN().getName());
        issuer.setCountry(((String)issuerDetails.get("C")).toString());
        issuer.setState((String)issuerDetails.get("ST"));
        issuer.setLocality((String)issuerDetails.get("L"));
        issuer.setOrganization((String)issuerDetails.get("O"));
        issuer.setOrganizationalUnit((String)issuerDetails.get("OU"));
        issuer.setCommonName((String)issuerDetails.get("CN"));
        return issuer;
    }
}

