/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.reports.service.impl;

import com.eabrokers.reports.data.ViewInformacionProcessDTO;
import com.eabrokers.reports.repository.ViewInformationProcessDAO;
import com.eabrokers.reports.service.DataReportTws;
import com.eabrokers.reports.views.ViewInformationProcess;
import com.eabrokers.utils.ApiResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DataReportTwsImpl
implements DataReportTws {
    private static final Logger log = LoggerFactory.getLogger(DataReportTwsImpl.class);
    private final ViewInformationProcessDAO viewInformationProcessDAO;

    public ResponseEntity<ApiResponse<?>> getRouteOfProcessByDate(LocalDateTime start, LocalDateTime end, int page, int size, String channel) {
        Page listSolicitudes;
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        System.out.println("canal: " + (String)channel);
        if (channel == null || ((String)channel).equalsIgnoreCase("todo") || ((String)channel).equalsIgnoreCase("undefined") || ((String)channel).equalsIgnoreCase("")) {
            listSolicitudes = this.viewInformationProcessDAO.getRouteOfProcessByDate(start, end, (Pageable)pageable);
        } else {
            channel = ";" + (String)channel + ";";
            listSolicitudes = this.viewInformationProcessDAO.getRouteOfProcessByDateAndLike(start, end, (String)channel, (Pageable)pageable);
        }
        List listProcessDTO = this.processViewExtractDataDto(listSolicitudes.getContent());
        PageImpl newContent = new PageImpl(listProcessDTO, listSolicitudes.getPageable(), listSolicitudes.getTotalElements());
        ApiResponse apiResponse = ApiResponse.ok((Object)newContent, (!newContent.isEmpty() ? 1 : 0) != 0);
        return ResponseEntity.ok((Object)apiResponse);
    }

    private List<ViewInformacionProcessDTO> processViewExtractDataDto(List<ViewInformationProcess> process) {
        ArrayList<ViewInformacionProcessDTO> newList = new ArrayList<ViewInformacionProcessDTO>();
        for (ViewInformationProcess pro : process) {
            ViewInformacionProcessDTO processDTO = new ViewInformacionProcessDTO(pro.getBiometricCode(), pro.getBiometricDate(), pro.getSignDate(), pro.getEstateSign(), this.extractChannel(pro.getCodigoInternoTws()));
            newList.add(processDTO);
        }
        return newList;
    }

    private String extractChannel(String value) {
        if (value == null) {
            return "";
        }
        try {
            String[] splittedValue = value.split(";");
            return splittedValue[3];
        }
        catch (Exception e) {
            return "";
        }
    }

    public ViewInformationProcessDAO getViewInformationProcessDAO() {
        return this.viewInformationProcessDAO;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataReportTwsImpl)) {
            return false;
        }
        DataReportTwsImpl other = (DataReportTwsImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ViewInformationProcessDAO this$viewInformationProcessDAO = this.getViewInformationProcessDAO();
        ViewInformationProcessDAO other$viewInformationProcessDAO = other.getViewInformationProcessDAO();
        return !(this$viewInformationProcessDAO == null ? other$viewInformationProcessDAO != null : !this$viewInformationProcessDAO.equals(other$viewInformationProcessDAO));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataReportTwsImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ViewInformationProcessDAO $viewInformationProcessDAO = this.getViewInformationProcessDAO();
        result = result * 59 + ($viewInformationProcessDAO == null ? 43 : $viewInformationProcessDAO.hashCode());
        return result;
    }

    public String toString() {
        return "DataReportTwsImpl(viewInformationProcessDAO=" + String.valueOf(this.getViewInformationProcessDAO()) + ")";
    }

    public DataReportTwsImpl(ViewInformationProcessDAO viewInformationProcessDAO) {
        this.viewInformationProcessDAO = viewInformationProcessDAO;
    }
}

