/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.reports.controller;

import com.eabrokers.reports.service.CallbackFirmaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(value={"*"})
@RequestMapping(value={"documents"})
public class DocumentsController {
    private static final Logger log = LoggerFactory.getLogger(DocumentsController.class);
    private final CallbackFirmaService callbackFirmaService;

    @PostMapping(value={"getListDocumentsByCode/{code}"})
    public ResponseEntity<?> getListDocumentsByCode(@PathVariable String code) {
        log.info("getListDocumentsByCode: code={}", (Object)code);
        return this.callbackFirmaService.getListDocumentsByCode(code);
    }

    @PostMapping(value={"getPdfByCode/{code}"})
    public ResponseEntity<?> getPdfByCode(@PathVariable String code) {
        return this.callbackFirmaService.getPdfFileFromCode(code);
    }

    public DocumentsController(CallbackFirmaService callbackFirmaService) {
        this.callbackFirmaService = callbackFirmaService;
    }
}

