/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.signPremise;

import com.eabrokers.common.transactions.TransactionCustom;
import com.eabrokers.exceptions.CustomException;
import com.eabrokers.logic.entity.enums.DocumentSignStatus;
import com.eabrokers.logic.entity.insurance.TDocumentTransaction;
import com.eabrokers.logic.entity.insurance.TDocumentTransactionDetail;
import com.eabrokers.logic.entity.insurance.TFileDocument;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentTransactionDetailService;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentTransactionService;
import com.eabrokers.logic.infrastructure.service.insurance.FileDocumentService;
import com.eabrokers.logic.infrastructure.service.insurance.StampDocumentService;
import com.eabrokers.logic.infrastructure.service.signPremise.SignWithCertificate;
import com.eabrokers.logic.model.CertificateModel;
import com.eabrokers.logic.model.DocumentoToSignModel;
import com.eabrokers.logic.model.FilesToSignModel;
import com.eabrokers.logic.model.LocalizacionModel;
import com.eabrokers.logic.model.SignModel;
import com.eabrokers.utils.ApiResponse;
import com.eabrokers.utils.CertificateDataExtractor;
import com.eabrokers.utils.FileUtil;
import com.eabrokers.utils.LocalizacionUtils;
import com.eabrokers.utils.RequestSignUtil;
import com.eabrokers.utils.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.signatures.BouncyCastleDigest;
import com.itextpdf.signatures.IExternalDigest;
import com.itextpdf.signatures.IExternalSignature;
import com.itextpdf.signatures.PdfSignatureAppearance;
import com.itextpdf.signatures.PdfSigner;
import com.itextpdf.signatures.PrivateKeySignature;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SignWithCertificateImpl
implements SignWithCertificate {
    private static final Logger log = LoggerFactory.getLogger(SignWithCertificateImpl.class);
    private final Environment env;
    private final ObjectMapper objectMapper;
    private final DocumentTransactionService documentTransactionService;
    private final DocumentTransactionDetailService documentTransactionDetailService;
    private final FileDocumentService fileDocumentService;
    private final StampDocumentService stampDocumentService;

    @PostConstruct
    public void init() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public ResponseEntity<?> signDocWithCertificate(MultipartFile certificate, String password, String body) {
        FilesToSignModel filesToSignModel = RequestSignUtil.getFilesToSignModel((ObjectMapper)this.objectMapper, (String)body);
        if (password == null) {
            throw new CustomException("La contrase\u00f1a del certificado es requerida", HttpStatus.BAD_REQUEST);
        }
        char[] passwordChars = password.toCharArray();
        if (certificate == null) {
            throw new CustomException("El certificado es requerido", HttpStatus.BAD_REQUEST);
        }
        try {
            KeyStore keyStore = this.loadKeyStore(certificate.getInputStream(), passwordChars);
            return this.signDocument(filesToSignModel, keyStore, passwordChars);
        }
        catch (Exception e) {
            log.error("Error al firmar el documento", (Throwable)e);
            throw new CustomException("Error al firmar el documento", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private ResponseEntity<?> signDocument(FilesToSignModel filesToSignModel, KeyStore keyStore, char[] password) {
        String tempPathSaveDoc = this.env.getProperty("ruta.temporal.firma");
        try {
            String alias = keyStore.aliases().nextElement();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password);
            Certificate[] certificateChain = keyStore.getCertificateChain(alias);
            CertificateModel certificateModel = this.extractInformation(keyStore, filesToSignModel.getIdentification());
            ArrayList<String> filesSigned = new ArrayList<String>();
            for (DocumentoToSignModel file : filesToSignModel.getFiles()) {
                String uuidString = UUID.randomUUID().toString();
                String basePathString = tempPathSaveDoc + uuidString;
                String dest = basePathString + ".pdf";
                String signedFile = this.signDocumentWithQRModel(file.getBase64(), certificateModel, privateKey, certificateChain, dest, file.getCoordenadaX(), file.getCoordenadaY(), file.getPageNumber(), basePathString);
                filesSigned.add(signedFile);
            }
            return ResponseEntity.ok(filesSigned);
        }
        catch (Exception e) {
            log.error("Error al firmar el documento", (Throwable)e);
            throw new CustomException("Error al firmar el documento", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private String signDocumentCustom(DocumentoToSignModel file, KeyStore keyStore, char[] password, String identification) {
        log.info(identification);
        String tempPathSaveDoc = this.env.getProperty("ruta.temporal.firma");
        try {
            String alias = keyStore.aliases().nextElement();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password);
            Certificate[] certificateChain = keyStore.getCertificateChain(alias);
            log.info("Start extractInformation:");
            CertificateModel certificateModel = this.extractInformation(keyStore, identification);
            String uuidString = UUID.randomUUID().toString();
            String basePathString = tempPathSaveDoc + uuidString;
            String dest = basePathString + ".pdf";
            String signedFile = this.signDocumentWithQRModel(file.getBase64(), certificateModel, privateKey, certificateChain, dest, file.getCoordenadaX(), file.getCoordenadaY(), file.getPageNumber(), basePathString);
            return signedFile;
        }
        catch (CustomException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error al firmar el documento", (Throwable)e);
            throw new CustomException("Error al firmar el documento", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<?> signDocWithQR(FilesToSignModel filesToSignModel) throws CustomException, Exception {
        log.info("Firmar documentos con c\u00f3digo QR");
        String rutaCertificado = this.env.getProperty("ruta.certificados");
        String tempPathSaveDoc = this.env.getProperty("ruta.temporal.firma");
        if (filesToSignModel.getIdentification().length() != 10) {
            filesToSignModel.setIdentification(filesToSignModel.getIdentification().substring(0, 10));
        }
        String pathCertificado = rutaCertificado + filesToSignModel.getIdentification() + "/";
        ArrayList<String> filesSigned = new ArrayList<String>();
        String keyStorePath = pathCertificado + filesToSignModel.getIdentification() + ".p12";
        log.info("Cargando firma electr\u00f3nica");
        char[] password = "Juano2012".toCharArray();
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(new FileInputStream(keyStorePath), password);
        log.info("Firma electr\u00f3nica cargada correctamente");
        String alias = ks.aliases().nextElement();
        PrivateKey pk = (PrivateKey)ks.getKey(alias, password);
        Certificate[] chain = ks.getCertificateChain(alias);
        CertificateModel certificateModel = this.extractInformation(ks, filesToSignModel.getIdentification());
        for (DocumentoToSignModel file : filesToSignModel.getFiles()) {
            String uuidString = UUID.randomUUID().toString();
            String basePathString = tempPathSaveDoc + uuidString;
            String dest = basePathString + ".pdf";
            String signedFile = this.signDocumentWithQRModel(file.getBase64(), certificateModel, pk, chain, dest, file.getCoordenadaX(), file.getCoordenadaY(), file.getPageNumber(), basePathString);
            filesSigned.add(signedFile);
        }
        return new ResponseEntity((Object)ApiResponse.ok(filesSigned, (boolean)true), (HttpStatusCode)HttpStatus.OK);
    }

    protected String signDocumentWithQRModel(String base64, CertificateModel certificateModel, PrivateKey pk, Certificate[] chain, String dest, String coordenadaX, String coordenadaY, String pageNumber, String basePathString) throws CustomException, Exception {
        log.info("Firmando documento con c\u00f3digo QR");
        byte[] decodedFile = Base64.getDecoder().decode(base64);
        ByteArrayInputStream source = new ByteArrayInputStream(decodedFile);
        PdfReader reader = new PdfReader((InputStream)source);
        log.info("Leyendo documento");
        FileOutputStream os = new FileOutputStream(dest);
        log.info("Creando firma {}", (Object)reader);
        PdfSigner signer = new PdfSigner(reader, (OutputStream)os, new StampingProperties().useAppendMode());
        log.info("Generando c\u00f3digo QR");
        String qrCodeData = new SignModel(certificateModel.getSubject().getFullName(), "", "").getFullData();
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        BitMatrix bitMatrix = qrCodeWriter.encode(qrCodeData, BarcodeFormat.QR_CODE, 50, 50, hints);
        Path qrPath = FileSystems.getDefault().getPath(basePathString + ".png", new String[0]);
        MatrixToImageWriter.writeToPath((BitMatrix)bitMatrix, (String)"PNG", (Path)qrPath);
        LocalizacionModel lm = LocalizacionUtils.getCoordenadas((String)coordenadaX, (String)coordenadaY, (String)pageNumber, (int)Utils.getPageNumber((byte[])decodedFile));
        PdfSignatureAppearance appearance = signer.getSignatureAppearance();
        appearance.setReason("");
        appearance.setLocation("");
        appearance.setSignatureGraphic(ImageDataFactory.create((URL)qrPath.toUri().toURL()));
        appearance.setLocationCaption("");
        appearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC_AND_DESCRIPTION);
        appearance.setLayer2Text("\nFirmado por:\n" + certificateModel.getSubject().getFullName());
        appearance.setLayer2FontSize(9.0f);
        appearance.setPageRect(new Rectangle(lm.getX(), lm.getY(), 200.0f, 50.0f));
        appearance.setPageNumber(lm.getPage());
        BouncyCastleDigest digest = new BouncyCastleDigest();
        PrivateKeySignature signature = new PrivateKeySignature(pk, "SHA256", "BC");
        signer.signDetached((IExternalDigest)digest, (IExternalSignature)signature, chain, null, null, null, 0, PdfSigner.CryptoStandard.CMS);
        reader.close();
        File file = new File(basePathString + ".pdf");
        File fileQR = new File(basePathString + ".png");
        byte[] fileContent = Files.readAllBytes(file.toPath());
        String encodedBase64String = Base64.getEncoder().encodeToString(fileContent);
        file.delete();
        fileQR.delete();
        return encodedBase64String;
    }

    protected CertificateModel extractInformation(KeyStore keyStore, String identificacion) throws CustomException, Exception {
        log.info("Extrayendo informaci\u00f3n del certificado");
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            CertificateDataExtractor extractor = new CertificateDataExtractor();
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            CertificateModel certModel = extractor.extractCertificateDetails(cert, identificacion);
            if (certModel.getValidTo().isBefore(LocalDateTime.now())) {
                throw new CustomException("El certificado ha expirado. Por favor, carga una nueva firma electr\u00f3nica.", HttpStatus.BAD_REQUEST);
            }
            if (certModel.getSubject().getSerialNumber() == null || certModel.getSerialNumber() == null) {
                log.error("Error al cargar el certificado. Verifique el numero de identificaci\u00f3n o contrase\u00f1a.");
                throw new CustomException("Error al cargar el certificado. Verifique el numero de identificaci\u00f3n o contrase\u00f1a.", HttpStatus.BAD_REQUEST);
            }
            if (!certModel.getSubject().getSerialNumber().contains(identificacion) && !certModel.getSerialNumber().contains(identificacion)) {
                log.error("El certificado no corresponde al usuario indicado.");
                throw new CustomException("El certificado no pertenece al usuario indicado.", HttpStatus.BAD_REQUEST);
            }
            return extractor.extractCertificateDetails(cert, identificacion);
        }
        log.warn("No se encontr\u00f3 un alias v\u00e1lido en el almac\u00e9n de claves.");
        throw new CustomException("No se encontr\u00f3 un certificado v\u00e1lido en el archivo proporcionado.", HttpStatus.BAD_REQUEST);
    }

    private KeyStore loadKeyStore(InputStream inputStream, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(inputStream, password);
        return ks;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> signAllDOcuments(MultipartFile firma, String password, String identification, List<String> body) {
        HashMap signedDocuments = new HashMap();
        if (firma == null || firma.isEmpty()) {
            throw new CustomException("El certificado es requerido.", HttpStatus.BAD_REQUEST);
        }
        if (password == null || password.trim().isEmpty()) {
            throw new CustomException("La contrase\u00f1a del certificado es requerida.", HttpStatus.BAD_REQUEST);
        }
        if (identification == null || identification.trim().isEmpty()) {
            throw new CustomException("El n\u00famero de identificaci\u00f3n es requerido.", HttpStatus.BAD_REQUEST);
        }
        if (body == null || body.isEmpty()) {
            throw new CustomException("La lista de documentos a firmar no puede estar vac\u00eda.", HttpStatus.BAD_REQUEST);
        }
        char[] passwordChars = password.toCharArray();
        try {
            KeyStore keyStore = this.loadKeyStore(firma.getInputStream(), passwordChars);
            List listDocumentDetail = this.getDocumentTransactionDetail(body);
            listDocumentDetail.forEach(documentDetail -> {
                TFileDocument dataFile = (TFileDocument)this.fileDocumentService.getFileById(documentDetail.getFileDocumentId()).orElseThrow(() -> new CustomException("Documento no encontrado. Verifique el ID e intente nuevamente.", HttpStatus.BAD_REQUEST));
                String fileSign = this.getDocumentFile(documentDetail, keyStore, passwordChars, identification, dataFile);
                if (fileSign != null) {
                    boolean responseUpdate = this.updateDetailDocuments(dataFile, fileSign, documentDetail);
                    signedDocuments.put(documentDetail.getDocumentTransactionId(), responseUpdate);
                }
            });
            this.notifyDocumentsSignForSure(signedDocuments);
            return TransactionCustom.ok();
        }
        catch (CustomException e) {
            throw e;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new CustomException("Error al cargar el certificado. Verifique el archivo y la contrase\u00f1a.", HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            throw new CustomException("Ocurri\u00f3 un error inesperado al firmar los documentos: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void notifyDocumentsSignForSure(Map<Long, Boolean> signedDocuments) {
        signedDocuments.forEach((id, status) -> {
            if (status.booleanValue()) {
                System.out.println("Documento ID: " + id + " - Firmado correctamente: " + status);
            }
        });
    }

    private String getDocumentFile(TDocumentTransactionDetail documentDetail, KeyStore keyStore, char[] passwordChars, String identification, TFileDocument dataFile) {
        String dataFileKey = this.stampDocumentService.findValueStringByDocumentInsuranceId(documentDetail.getDocumentInsuranceId(), "signInsurance_C1_1");
        if (dataFileKey != null) {
            String fileBase64 = FileUtil.convertToBase64String((byte[])dataFile.getFile());
            DocumentoToSignModel documentoToSignModel = this.convertListFilesToSignModel(fileBase64, SignWithCertificateImpl.extractNumbers((String)dataFileKey));
            return this.signDocumentCustom(documentoToSignModel, keyStore, passwordChars, identification);
        }
        return null;
    }

    private List<TDocumentTransactionDetail> getDocumentTransactionDetail(List<String> body) {
        return body.stream().map(idValue -> {
            try {
                return Long.parseLong(idValue);
            }
            catch (NumberFormatException e) {
                log.error("No se pudo convertir el ID: {}", idValue, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).flatMap(id -> this.documentTransactionDetailService.findByDocumentTransactionId(id).stream()).filter(detail -> "CERTIFICATE".equals(detail.getDocumentName())).collect(Collectors.toList());
    }

    private List<TDocumentTransactionDetail> gocumentTransactionDetail(List<String> body) {
        List<TDocumentTransactionDetail> listDocumentDetail = body.stream().map(idValue -> {
            try {
                return Long.parseLong(idValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).filter(Objects::nonNull).map(arg_0 -> ((DocumentTransactionDetailService)this.documentTransactionDetailService).findById(arg_0)).flatMap(Optional::stream).filter(item -> item.getDocumentDetailStatus() == DocumentSignStatus.SIGNED_USER).collect(Collectors.toList());
        if (listDocumentDetail.isEmpty()) {
            throw new CustomException("La lista de IDs de los documentos est\u00e1 vac\u00eda.", HttpStatus.BAD_REQUEST);
        }
        if (body.size() != listDocumentDetail.size()) {
            throw new CustomException("Uno o m\u00e1s documentos tienen un ID no v\u00e1lido.", HttpStatus.BAD_REQUEST);
        }
        return listDocumentDetail;
    }

    private boolean updateDetailDocuments(TFileDocument fileDocumentTemp, String fileBase64, TDocumentTransactionDetail documentTransactionDetail) {
        try {
            if (fileBase64 == null || fileBase64.isBlank()) {
                log.error("Base64 del archivo es nulo o vac\u00edo.");
                return false;
            }
            fileDocumentTemp.setFile(FileUtil.base64ToByte((String)fileBase64));
            this.fileDocumentService.save(fileDocumentTemp);
            documentTransactionDetail.setDocumentDetailStatus(DocumentSignStatus.SIGNED_SURE);
            this.documentTransactionDetailService.save(documentTransactionDetail);
            Optional transactionOpt = this.documentTransactionService.findById(documentTransactionDetail.getDocumentTransactionId());
            if (!transactionOpt.isPresent()) {
                log.error("No se encontr\u00f3 la transacci\u00f3n con ID: {}", (Object)documentTransactionDetail.getDocumentTransactionId());
                return false;
            }
            TDocumentTransaction transaction = (TDocumentTransaction)transactionOpt.get();
            transaction.setDocumentStatus(TDocumentTransaction.DocumentStatus.SIGNED_INSURANCE);
            this.documentTransactionService.save(transaction);
            return true;
        }
        catch (IllegalArgumentException e) {
            log.error("Error en conversi\u00f3n de Base64 a bytes: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        catch (DataAccessException e) {
            log.error("Error de base de datos al actualizar documentos: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        catch (Exception e) {
            log.error("Error inesperado al actualizar documentos: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private DocumentoToSignModel convertListFilesToSignModel(String base64, List<Integer> keyLocation) {
        DocumentoToSignModel documentoToSignModel = new DocumentoToSignModel();
        documentoToSignModel.setBase64(base64);
        documentoToSignModel.setCoordenadaY("" + (keyLocation.get(2) - 30));
        documentoToSignModel.setCoordenadaX("" + (keyLocation.get(1) - 30));
        documentoToSignModel.setPageNumber(keyLocation.get(0).toString());
        return documentoToSignModel;
    }

    public static List<Integer> extractNumbers(String input) {
        return Arrays.stream(input.replace(";", "").split("&")).map(Integer::parseInt).collect(Collectors.toList());
    }

    public SignWithCertificateImpl(Environment env, ObjectMapper objectMapper, DocumentTransactionService documentTransactionService, DocumentTransactionDetailService documentTransactionDetailService, FileDocumentService fileDocumentService, StampDocumentService stampDocumentService) {
        this.env = env;
        this.objectMapper = objectMapper;
        this.documentTransactionService = documentTransactionService;
        this.documentTransactionDetailService = documentTransactionDetailService;
        this.fileDocumentService = fileDocumentService;
        this.stampDocumentService = stampDocumentService;
    }
}

