/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.lhia;

import com.eabrokers.logic.data.ConversacionUsuario;
import com.eabrokers.logic.data.TokenResponseSeguros;
import com.eabrokers.logic.infrastructure.service.lhia.ChatService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ChatServiceImpl
implements ChatService {
    private static final Logger log = LoggerFactory.getLogger(ChatServiceImpl.class);
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.urlAnswer}")
    private String urlAnswer;
    @Value(value="${openai.modelAnswer}")
    private String modelAnswer;
    private final RestTemplate restTemplate = new RestTemplate();
    private Map<String, List<ConversacionUsuario>> historialUsuarios = new HashMap();
    private final String tokenUrl = "https://pruebas-biometria.tws2.io/eabrokers/v1/token";
    private final String insuranceUrl = "https://pruebas-biometria.tws2.io/eabrokers/v1/insurances/listInsurance";

    public String pregunta(String question, String identificador) {
        String textSystem = "Eres Lhia, una asistente virtual creada por TWS2, empresa ecuatoriana con sede en Cuenca. Tu funci\u00f3n principal es asistir en la venta de seguros.\n\n1. Act\u00faas como asistente de ventas de seguros.\n2. Cuando el usuario haya seleccionado el seguro que desea adquirir, debes recopilar la siguiente informaci\u00f3n, solicit\u00e1ndola una por una:\n   - N\u00famero de c\u00e9dula\n   - Nombres completos (primer y segundo nombre en un solo mensaje)\n   - Apellidos completos (primer y segundo apellido en un solo mensaje)\n   - Correo electr\u00f3nico\n   - Tipo de prima deseada (mensual o anual)\n3. Una vez que el usuario proporcione los nombres completos, sep\u00e1ralos en:\n   - primerNombre: la primera palabra\n   - segundoNombre: el resto del texto (si hay m\u00e1s de una palabra, \u00fanelas con espacio)\n   Aplica lo mismo con los apellidos:\n   - primerApellido: la primera palabra\n   - segundoApellido: el resto del texto (si hay m\u00e1s de una palabra, \u00fanelas con espacio)\n4. A partir del contexto proporcionado con la informaci\u00f3n de los seguros, identifica:\n   - El ID del seguro seleccionado (campo `id`)\n   - El ID de la prima seleccionada seg\u00fan la descripci\u00f3n (campo `description`)\n5. Una vez que tengas todos los datos, organ\u00edzalos en el siguiente formato JSON (sin mostrarlo a\u00fan):\n   {\n\t \"idSeguro\": \"\",\n\t \"seguro\": \"\",\n\t \"cedula\": \"\",\n\t \"primerNombre\": \"\",\n\t \"segundoNombre\": \"\",\n\t \"primerApellido\": \"\",\n\t \"segundoApellido\": \"\",\n\t \"correo\": \"\",\n\t \"prima\": \"\",\n\t \"idPrima\": \"\"\n   }\n6. Despu\u00e9s de recopilar toda la informaci\u00f3n, presenta un resumen al usuario y solicita confirmaci\u00f3n preguntando si desea continuar o modificar alg\u00fan dato. **En este resumen no se debe mostrar el `idSeguro` ni el `idPrima`, ya que son datos internos y privados.**\n7. Si el usuario confirma que desea continuar, responde **\u00fanicamente con el JSON plano y v\u00e1lido**, sin ning\u00fan texto adicional, sin formato Markdown ni caracteres especiales.\n8. La informaci\u00f3n de los seguros y primas se entrega en el contexto.\n9. En tus respuestas, enf\u00f3cate exclusivamente en detalles relevantes como el nombre, costo y descripci\u00f3n de los seguros. Omite cualquier informaci\u00f3n que no est\u00e9 directamente relacionada con esto.\n";
        List conversacionUsuario = this.historialUsuarios.computeIfAbsent(identificador, k -> new ArrayList());
        if (conversacionUsuario.isEmpty()) {
            conversacionUsuario.add(new ConversacionUsuario("system", textSystem));
            conversacionUsuario.add(new ConversacionUsuario("user", "contexto: " + this.getFormattedInsuranceData()));
        }
        conversacionUsuario.add(new ConversacionUsuario("user", question));
        String respuestaFinal = this.respondePreguntasV2(conversacionUsuario);
        conversacionUsuario.add(new ConversacionUsuario("assistant", respuestaFinal));
        return respuestaFinal;
    }

    private String respondePreguntasV2(List<ConversacionUsuario> lstConversation) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("messages", lstConversation);
        requestBody.put("model", (Object)this.modelAnswer);
        requestBody.put("max_tokens", 500);
        requestBody.put("temperature", 0.3);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity((Object)requestBody.toString(), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        System.out.println("respuesta GPT: " + text);
        return text;
    }

    public String getToken() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.set("Authorization", "Basic VFdTMi1ERVNBUlJPTExPOmFiMWE0MDY2NjI4MjNlZGRiYmMyZGM1NjE0YzY4Mjc5");
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"pin", (Object)"4274977394452973");
        HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity("https://pruebas-biometria.tws2.io/eabrokers/v1/token", (Object)request, TokenResponseSeguros.class, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK && response.getBody() != null) {
            return ((TokenResponseSeguros)response.getBody()).getData().getTkn_token();
        }
        throw new RuntimeException("No se pudo obtener el token");
    }

    public String getFormattedInsuranceData() {
        String bearerToken = this.getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setBearerAuth(bearerToken);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"codeInsurance", (Object)"203c973a-ffee-4c79-bee5-2b7177abc5d1");
        HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity("https://pruebas-biometria.tws2.io/eabrokers/v1/insurances/listInsurance", (Object)request, String.class, new Object[0]);
        return response.toString();
    }
}

