/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.common.transactions.TransactionCustom;
import com.eabrokers.logic.dto.TransactionSummaryDTO;
import com.eabrokers.logic.infrastructure.service.insurance.PlanTypeService;
import com.eabrokers.logic.infrastructure.service.insurance.TransactionSummaryViewService;
import com.eabrokers.logic.model.view.TransactionSummaryView;
import com.eabrokers.logic.repository.insurance.TransactionSummaryViewDAO;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class TransactionSummaryViewServiceImpl
implements TransactionSummaryViewService {
    private final TransactionSummaryViewDAO transactionSummaryViewDAO;
    private final PlanTypeService planTypeService;

    public ResponseEntity<?> getTransactionSummaryViewById(Long id) {
        Optional summaryView = this.transactionSummaryViewDAO.findById((Object)id);
        if (summaryView.isPresent()) {
            TransactionSummaryDTO summaryDTO = TransactionSummaryDTO.convertToDTO((TransactionSummaryView)((TransactionSummaryView)summaryView.get()));
            double invoiceValue = this.planTypeService.calculatePlanValue(summaryDTO.getInclusiveInsuranceId());
            summaryDTO.setInvoiceValue(Double.valueOf(invoiceValue));
            return TransactionCustom.ok((Object)summaryDTO);
        }
        return TransactionCustom.error((String)"Element not found");
    }

    public ResponseEntity<?> listTransactionSummaryView() {
        List list = this.transactionSummaryViewDAO.findByDocumentStatus("SIGNED_INSURANCE");
        List dtoList = list.stream().map(TransactionSummaryDTO::convertToDTO).collect(Collectors.toList());
        return TransactionCustom.ok(dtoList);
    }

    public TransactionSummaryViewServiceImpl(TransactionSummaryViewDAO transactionSummaryViewDAO, PlanTypeService planTypeService) {
        this.transactionSummaryViewDAO = transactionSummaryViewDAO;
        this.planTypeService = planTypeService;
    }
}

