/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.logic.entity.insurance.TDocumentInsurance;
import com.eabrokers.logic.entity.insurance.TDocumentTransaction;
import com.eabrokers.logic.entity.insurance.TFileDocument;
import com.eabrokers.logic.entity.insurance.TFinancialAccount;
import com.eabrokers.logic.entity.insurance.TInsuredPerson;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentInsuranceService;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentTransactionService;
import com.eabrokers.logic.infrastructure.service.insurance.FileDocumentService;
import com.eabrokers.logic.infrastructure.service.insurance.FinancialAccountService;
import com.eabrokers.logic.infrastructure.service.insurance.InsuredPersonService;
import com.eabrokers.logic.infrastructure.service.insurance.LinkService;
import com.eabrokers.logic.infrastructure.service.insurance.SignDocumentTransactionService;
import com.eabrokers.logic.infrastructure.service.insurance.StampDocumentService;
import com.eabrokers.logic.request.BiometricDocumentRequest;
import com.eabrokers.logic.request.DocumentRequest;
import com.eabrokers.utils.FileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class SignDocumentTransactionServiceImpl
implements SignDocumentTransactionService {
    private final DocumentTransactionService documentTransactionService;
    private final FinancialAccountService financialAccountService;
    private final InsuredPersonService insuredPersonService;
    private final FileDocumentService fileDocumentService;
    private final DocumentInsuranceService documentInsuranceService;
    private final StampDocumentService stampDocumentService;
    private final LinkService linkService;

    public BiometricDocumentRequest signDocumentTransaction(Long documentTransactionId) {
        TDocumentTransaction documentTransactionFind = this.documentTransactionService.documentTransactionFindById(documentTransactionId);
        Optional financialAccountFind = this.financialAccountService.findById(documentTransactionFind.getFinancialAccountId());
        Optional insuredPersonFind = this.insuredPersonService.findById(((TFinancialAccount)financialAccountFind.get()).getInsuredPersonId());
        return this.biometricDocumentRequest(documentTransactionFind, (TInsuredPerson)insuredPersonFind.get());
    }

    public BiometricDocumentRequest biometricDocumentRequest(TDocumentTransaction documentTransactionFind, TInsuredPerson insuredPerson) {
        String callbackSignDocument = this.linkService.pathCallbackBiometria();
        ArrayList listDocumentRequests = new ArrayList();
        documentTransactionFind.getDocumentTransactionDetail().forEach(data -> {
            Optional documentInsurance = this.documentInsuranceService.findById(data.getDocumentInsuranceId());
            Optional fileDocument = this.fileDocumentService.getFileById(data.getFileDocumentId());
            DocumentRequest documentAuthorization = new DocumentRequest();
            String coordFind = this.stampDocumentService.findValueStringByDocumentInsuranceId(((TDocumentInsurance)documentInsurance.get()).getId(), "sign_A1_1");
            String coordSign = this.getCoordSign(coordFind);
            String page = this.getCoordPage(coordFind);
            documentAuthorization.setNombre(((TDocumentInsurance)documentInsurance.get()).getTypeDocument().toUpperCase());
            documentAuthorization.setTipo("SIMPLE");
            documentAuthorization.setArchivoBase64(FileUtil.convertToBase64String((byte[])((TFileDocument)fileDocument.get()).getFile()));
            documentAuthorization.setCoordenada(coordSign);
            documentAuthorization.setPagina(page);
            listDocumentRequests.add(documentAuthorization);
        });
        BiometricDocumentRequest request = new BiometricDocumentRequest();
        request.setCodigoCliente("2");
        request.setIdentificacion(insuredPerson.getIdentification());
        request.setNombres(insuredPerson.getFirstName() + " " + insuredPerson.getMiddleName());
        request.setApellidoPaterno(insuredPerson.getLastName());
        request.setApellidoMaterno(insuredPerson.getSecondLastName());
        request.setEmail(insuredPerson.getEmail());
        request.setCelular(insuredPerson.getPhone());
        request.setDomicilio(insuredPerson.getAddress());
        request.setCiudad(insuredPerson.getCity());
        request.setDocumentos(listDocumentRequests);
        request.setCallback(callbackSignDocument);
        request.setMotivo("SEGURO TEST");
        request.setCanal(documentTransactionFind.getNotifyType().name());
        request.setOrigen("SEGURO");
        return request;
    }

    public String getCoordSign(String coordFind) {
        List listData = this.parseStringToList(coordFind);
        int coordX = (Integer)listData.get(1) - 30;
        int coordY = (Integer)listData.get(2) - 30;
        return coordX + "," + coordY + ",365,60";
    }

    public String getCoordPage(String coordFind) {
        List listData = this.parseStringToList(coordFind);
        return ((Integer)listData.get(0)).toString();
    }

    public List<Integer> parseStringToList(String input) {
        String[] values;
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        if (input.endsWith(";")) {
            input = input.substring(0, input.length() - 1);
        }
        for (String value : values = input.split("&")) {
            numbers.add(Integer.parseInt(value));
        }
        return numbers;
    }

    public SignDocumentTransactionServiceImpl(DocumentTransactionService documentTransactionService, FinancialAccountService financialAccountService, InsuredPersonService insuredPersonService, FileDocumentService fileDocumentService, DocumentInsuranceService documentInsuranceService, StampDocumentService stampDocumentService, LinkService linkService) {
        this.documentTransactionService = documentTransactionService;
        this.financialAccountService = financialAccountService;
        this.insuredPersonService = insuredPersonService;
        this.fileDocumentService = fileDocumentService;
        this.documentInsuranceService = documentInsuranceService;
        this.stampDocumentService = stampDocumentService;
        this.linkService = linkService;
    }
}

