/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.common.transactions.TransactionCustom;
import com.eabrokers.logic.dto.PreInsuredDocumentDTO;
import com.eabrokers.logic.entity.insurance.TBiometricTransaction;
import com.eabrokers.logic.infrastructure.service.biometria.UanatacaService;
import com.eabrokers.logic.infrastructure.service.insurance.BiometricTransactionService;
import com.eabrokers.logic.infrastructure.service.insurance.PreSignDocumentTransactionService;
import com.eabrokers.logic.infrastructure.service.insurance.SignDocumentService;
import com.eabrokers.logic.infrastructure.service.insurance.SignDocumentTransactionService;
import com.eabrokers.logic.request.BiometricDocumentRequest;
import com.eabrokers.logic.request.DocumentRequest;
import com.eabrokers.logic.response.BiometricResponse;
import com.eabrokers.logic.response.StampCustomResponse;
import com.eabrokers.logic.response.UrlBiometricResponse;
import com.eabrokers.utils.ApiResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SignDocumentServiceImpl
implements SignDocumentService {
    private static final Logger log = LoggerFactory.getLogger(SignDocumentServiceImpl.class);
    private final PreSignDocumentTransactionService preSignDocumentTransactionService;
    private final SignDocumentTransactionService signDocumentTransactionService;
    private final BiometricTransactionService biometricTransactionService;
    private final UanatacaService uanatacaService;

    public ResponseEntity<?> preSignDocumentAuthorization(PreInsuredDocumentDTO preInsuredDocumentDTO) {
        StampCustomResponse dataStampCustomResponse = this.preSignDocumentTransactionService.createStampCustomResponse(preInsuredDocumentDTO);
        return TransactionCustom.ok((Object)dataStampCustomResponse);
    }

    public ResponseEntity<?> documentTransactionById(Long documentTransactionId) {
        BiometricDocumentRequest biometricDocumentRequest = this.signDocumentTransactionService.signDocumentTransaction(documentTransactionId);
        ResponseEntity dataResponse = this.biometricDocumentRequest(biometricDocumentRequest);
        if (dataResponse.getStatusCode().value() == 200) {
            BiometricResponse biometricResponse = SignDocumentServiceImpl.convertDataBiometricResponse((Object)dataResponse.getBody());
            TBiometricTransaction transactionTemp = this.createBiometricTransaction(biometricResponse, documentTransactionId);
            this.biometricTransactionService.save(transactionTemp);
            UrlBiometricResponse urlBiometric = new UrlBiometricResponse();
            urlBiometric.setCodeBiometric(transactionTemp.getCodeBiometric());
            urlBiometric.setShortUrl(biometricResponse.getData().getShortUrl());
            urlBiometric.setUrl(biometricResponse.getData().getUrl());
            return TransactionCustom.ok((Object)urlBiometric);
        }
        return TransactionCustom.error();
    }

    private TBiometricTransaction createBiometricTransaction(BiometricResponse biometricResponse, Long documentTransactionId) {
        TBiometricTransaction transaction = new TBiometricTransaction();
        transaction.setCodeBiometric(biometricResponse.getData().getCode());
        transaction.setDocumentTransactionId(documentTransactionId);
        return transaction;
    }

    public static BiometricResponse convertDataBiometricResponse(Object body) {
        if (body == null) {
            log.error("Body es [null]");
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        BiometricResponse biometricResponse = new BiometricResponse();
        try {
            if (body instanceof ApiResponse) {
                ApiResponse apiResponse = (ApiResponse)body;
                biometricResponse.setStatus(apiResponse.getStatus());
                Object dataObject = apiResponse.getData();
                if (dataObject != null) {
                    BiometricResponse.DataBiometric dataBiometric = (BiometricResponse.DataBiometric)objectMapper.convertValue(dataObject, BiometricResponse.DataBiometric.class);
                    biometricResponse.setData(dataBiometric);
                }
            } else {
                log.error("Tipo de body inesperado " + body.getClass().getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return biometricResponse;
    }

    private ResponseEntity<?> biometricDocumentRequest(BiometricDocumentRequest biometricDocumentRequest) {
        ResponseEntity dataResponse = this.uanatacaService.solicitarBiometriaFirmaFlujoUnico(biometricDocumentRequest.getCodigoCliente(), biometricDocumentRequest.getIdentificacion(), biometricDocumentRequest.getNombres(), biometricDocumentRequest.getApellidoPaterno(), biometricDocumentRequest.getApellidoMaterno(), biometricDocumentRequest.getEmail(), biometricDocumentRequest.getCelular(), biometricDocumentRequest.getDomicilio(), biometricDocumentRequest.getCiudad(), this.listDocumentsToString(biometricDocumentRequest.getDocumentos()), biometricDocumentRequest.getMotivo(), biometricDocumentRequest.getOrigen(), biometricDocumentRequest.getCallback(), biometricDocumentRequest.getCanal());
        return dataResponse;
    }

    private String listDocumentsToString(List<DocumentRequest> listDocumentRequest) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String documentJson = objectMapper.writeValueAsString(listDocumentRequest);
            return documentJson;
        }
        catch (Exception e) {
            throw new RuntimeException("Error al serializar los documentos", e);
        }
    }

    public SignDocumentServiceImpl(PreSignDocumentTransactionService preSignDocumentTransactionService, SignDocumentTransactionService signDocumentTransactionService, BiometricTransactionService biometricTransactionService, UanatacaService uanatacaService) {
        this.preSignDocumentTransactionService = preSignDocumentTransactionService;
        this.signDocumentTransactionService = signDocumentTransactionService;
        this.biometricTransactionService = biometricTransactionService;
        this.uanatacaService = uanatacaService;
    }
}

