/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.logic.data.DataFileDocumentSign;
import com.eabrokers.logic.data.DocumentValue;
import com.eabrokers.logic.dto.InsuredDocumentDTO;
import com.eabrokers.logic.dto.PreInsuredDocumentDTO;
import com.eabrokers.logic.entity.insurance.TBranch;
import com.eabrokers.logic.entity.insurance.TDocumentInsurance;
import com.eabrokers.logic.entity.insurance.TDocumentTransaction;
import com.eabrokers.logic.entity.insurance.TFinancialAccount;
import com.eabrokers.logic.entity.insurance.TFinancialInstitution;
import com.eabrokers.logic.entity.insurance.TInclusiveInsurance;
import com.eabrokers.logic.entity.insurance.TInsuranceCompany;
import com.eabrokers.logic.entity.insurance.TInsuredPerson;
import com.eabrokers.logic.infrastructure.service.insurance.BranchService;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentFileService;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentTransactionDetailService;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentTransactionService;
import com.eabrokers.logic.infrastructure.service.insurance.FileDocumentService;
import com.eabrokers.logic.infrastructure.service.insurance.FinancialAccountService;
import com.eabrokers.logic.infrastructure.service.insurance.FinancialInstitutionService;
import com.eabrokers.logic.infrastructure.service.insurance.InclusiveInsuranceService;
import com.eabrokers.logic.infrastructure.service.insurance.InsuranceCompanyService;
import com.eabrokers.logic.infrastructure.service.insurance.InsuredPersonService;
import com.eabrokers.logic.infrastructure.service.insurance.LinkService;
import com.eabrokers.logic.infrastructure.service.insurance.PlanTypeService;
import com.eabrokers.logic.infrastructure.service.insurance.PreSignDocumentTransactionService;
import com.eabrokers.logic.response.StampCustomResponse;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class PreSignDocumentTransactionServiceImpl
implements PreSignDocumentTransactionService {
    private final DocumentFileService documentFileService;
    private final InsuredPersonService insuredPersonService;
    private final FinancialAccountService financialAccountService;
    private final DocumentTransactionService documentTransactionService;
    private final DocumentTransactionDetailService documentTransactionDetailService;
    private final InclusiveInsuranceService inclusiveInsuranceService;
    private final FinancialInstitutionService financialInstitutionService;
    private final InsuranceCompanyService insuranceCompanyService;
    private final BranchService branchService;
    private final PlanTypeService planTypeService;
    private final FileDocumentService fileDocumentService;
    private final LinkService linkService;

    public StampCustomResponse createStampCustomResponse(PreInsuredDocumentDTO preInsuredDocumentDTO) {
        InsuredDocumentDTO insuredDocumentDTO = this.buildInsuredDocumentDTO(preInsuredDocumentDTO);
        insuredDocumentDTO.setAccountTypeId(Long.valueOf(1L));
        insuredDocumentDTO.setInsuredPartnerActive(false);
        TInsuredPerson insuredPerson = this.insuredPersonService.createInsuredPerson(insuredDocumentDTO.getInsuredPerson());
        TInclusiveInsurance dataInclusiveInsurance = (TInclusiveInsurance)this.inclusiveInsuranceService.findInclusiveInsuranceByPrimaId(insuredDocumentDTO.getPrimaId()).get();
        Long financialInstitutionId = dataInclusiveInsurance.getFinancialInstitutionId();
        double valuePlan = this.planTypeService.calculatePlanValue(dataInclusiveInsurance.getId());
        TFinancialInstitution dataFinancialInstitution = (TFinancialInstitution)this.financialInstitutionService.getFinancialInstitutionById(financialInstitutionId).get();
        TInsuranceCompany dataInsuranceCompany = (TInsuranceCompany)this.insuranceCompanyService.getInsuranceCompanyById(dataInclusiveInsurance.getInsuranceCompanyId()).get();
        TBranch dataBranch = (TBranch)this.branchService.findById(dataInclusiveInsurance.getBranchId()).get();
        DataFileDocumentSign dataDocumentSign = this.documentFileService.findDocumentsSign(insuredDocumentDTO);
        TDocumentInsurance documentInsuranceAuthorization = dataDocumentSign.getDocumentInsuranceAuthorization();
        TDocumentInsurance documentInsuranceCertificate = dataDocumentSign.getDocumentInsuranceCertificate();
        String authorizationFileId = this.fileDocumentService.getDocumentFileId(insuredDocumentDTO, dataInclusiveInsurance, valuePlan, dataFinancialInstitution, dataInsuranceCompany, dataBranch, dataDocumentSign, dataDocumentSign.getFileDocumentAuthorization(), dataDocumentSign.getFrequencyId(), documentInsuranceAuthorization);
        String certificateFileId = this.fileDocumentService.getDocumentFileId(insuredDocumentDTO, dataInclusiveInsurance, valuePlan, dataFinancialInstitution, dataInsuranceCompany, dataBranch, dataDocumentSign, dataDocumentSign.getFileDocumentCertificate(), dataDocumentSign.getFrequencyId(), documentInsuranceCertificate);
        TFinancialAccount financialAccountSaved = this.financialAccountService.saveFinancialAccount(insuredDocumentDTO, financialInstitutionId, insuredPerson.getId());
        TDocumentTransaction documentTransactionSaved = this.documentTransactionService.saveDocumentTransaction(insuredDocumentDTO, financialAccountSaved.getId(), 2, preInsuredDocumentDTO);
        this.documentTransactionDetailService.saveDocumentTransactionDetail(documentTransactionSaved.getId(), documentInsuranceAuthorization.getId(), authorizationFileId, documentInsuranceAuthorization.getTypeDocument());
        this.documentTransactionDetailService.saveDocumentTransactionDetail(documentTransactionSaved.getId(), documentInsuranceCertificate.getId(), certificateFileId, documentInsuranceCertificate.getTypeDocument());
        List<DocumentValue> listDocumentValue = List.of(this.createDocumentValue("Certificate", certificateFileId, "Documento de Certificado"), this.createDocumentValue("Authorization", authorizationFileId, "Documento de Autorizaci\u00f3n"));
        StampCustomResponse dataStampCustomResponse = new StampCustomResponse(documentTransactionSaved.getId(), listDocumentValue);
        return dataStampCustomResponse;
    }

    private InsuredDocumentDTO buildInsuredDocumentDTO(PreInsuredDocumentDTO preInsuredDocumentDTO) {
        InsuredDocumentDTO dto = new InsuredDocumentDTO();
        dto.setInsuredPerson(preInsuredDocumentDTO.getInsuredPerson());
        dto.setPrimaId(preInsuredDocumentDTO.getPrimaId());
        dto.setNumberDebitForm(preInsuredDocumentDTO.getNumberDebitForm());
        dto.setAccountTypeId(Long.valueOf(1L));
        dto.setInsuredPartnerActive(false);
        return dto;
    }

    private DocumentValue createDocumentValue(String name, String fileId, String description) {
        DocumentValue documentValue = new DocumentValue();
        documentValue.setName(name);
        documentValue.setDescription(description);
        documentValue.setUrlDocument(this.linkService.linkFilesDocs(fileId));
        return documentValue;
    }

    public PreSignDocumentTransactionServiceImpl(DocumentFileService documentFileService, InsuredPersonService insuredPersonService, FinancialAccountService financialAccountService, DocumentTransactionService documentTransactionService, DocumentTransactionDetailService documentTransactionDetailService, InclusiveInsuranceService inclusiveInsuranceService, FinancialInstitutionService financialInstitutionService, InsuranceCompanyService insuranceCompanyService, BranchService branchService, PlanTypeService planTypeService, FileDocumentService fileDocumentService, LinkService linkService) {
        this.documentFileService = documentFileService;
        this.insuredPersonService = insuredPersonService;
        this.financialAccountService = financialAccountService;
        this.documentTransactionService = documentTransactionService;
        this.documentTransactionDetailService = documentTransactionDetailService;
        this.inclusiveInsuranceService = inclusiveInsuranceService;
        this.financialInstitutionService = financialInstitutionService;
        this.insuranceCompanyService = insuranceCompanyService;
        this.branchService = branchService;
        this.planTypeService = planTypeService;
        this.fileDocumentService = fileDocumentService;
        this.linkService = linkService;
    }
}

