/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.logic.client.BotpressApiClient;
import com.eabrokers.logic.dto.InvoiceFakeDTO;
import com.eabrokers.logic.dto.NotificationBotpressDTO;
import com.eabrokers.logic.entity.insurance.TDocumentTransaction;
import com.eabrokers.logic.entity.insurance.TFileDocument;
import com.eabrokers.logic.entity.insurance.TInsuredPerson;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentTransactionDetailService;
import com.eabrokers.logic.infrastructure.service.insurance.EmailCustomService;
import com.eabrokers.logic.infrastructure.service.insurance.FileDocumentService;
import com.eabrokers.logic.infrastructure.service.insurance.InsuredPersonService;
import com.eabrokers.logic.infrastructure.service.insurance.NotifySignService;
import com.eabrokers.logic.model.FileEmail;
import com.eabrokers.utils.FileUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NotifySignServiceImpl
implements NotifySignService {
    private static final Logger log = LoggerFactory.getLogger(NotifySignServiceImpl.class);
    private final BotpressApiClient botpressApiClient;
    private final EmailCustomService emailCustomService;
    private final DocumentTransactionDetailService documentTransactionDetailService;
    private final FileDocumentService fileDocumentService;
    private final InsuredPersonService insuredPersonService;

    public boolean notifyDocumentStatus(TDocumentTransaction documentTransaction, TDocumentTransaction.DocumentStatus documentStatus, InvoiceFakeDTO invoice) {
        TInsuredPerson insuredPerson = (TInsuredPerson)this.insuredPersonService.findByTransactionId(documentTransaction.getId()).orElseThrow(() -> new RuntimeException("No se encontr\u00f3 la persona asegurada con ID Transaction:" + documentTransaction.getId()));
        List listFileEmail = this.getFileListEmail(documentTransaction.getId());
        if (listFileEmail.size() > 0 && (TDocumentTransaction.DocumentStatus.SIGNED_INSURANCE == documentStatus || TDocumentTransaction.DocumentStatus.SIGNED_USER == documentStatus)) {
            this.notifyEmailSend(insuredPerson, listFileEmail, documentStatus, invoice);
        } else {
            log.warn("No fue posible notificar a Email.");
        }
        if (documentTransaction.getNotifyType() == TDocumentTransaction.NotifyType.WHATSAPP) {
            this.notifyBotpressSend(documentTransaction, documentStatus);
        }
        return true;
    }

    private boolean notifyEmailSend(TInsuredPerson person, List<FileEmail> listFileEmail, TDocumentTransaction.DocumentStatus documentStatus, InvoiceFakeDTO invoice) {
        return this.emailCustomService.sendEmailUser(person, listFileEmail, documentStatus, invoice);
    }

    private boolean notifyBotpressSend(TDocumentTransaction documentTransaction, TDocumentTransaction.DocumentStatus documentStatus) {
        NotificationBotpressDTO notificationBotpressTemp = this.notificationBotpress(documentTransaction, documentStatus);
        Optional respApi = this.botpressApiClient.sendWebhookMessage(notificationBotpressTemp);
        if (respApi.isEmpty()) {
            log.warn("Botpress could not be notified.");
            return false;
        }
        return true;
    }

    private List<FileEmail> getFileListEmail(Long idDocumentTransaction) {
        return this.documentTransactionDetailService.findByDocumentTransactionId(idDocumentTransaction).stream().map(detail -> {
            Optional fileOpt = this.fileDocumentService.getFileById(detail.getFileDocumentId());
            if (fileOpt.isPresent()) {
                TFileDocument file = (TFileDocument)fileOpt.get();
                FileEmail dataFileEmail = new FileEmail();
                dataFileEmail.setFileName(detail.getDocumentName().toLowerCase() + ".pdf");
                dataFileEmail.setFileBase64(FileUtil.convertToBase64String((byte[])file.getFile()));
                return dataFileEmail;
            }
            log.warn("No se encontr\u00f3 el archivo con ID: {}", (Object)detail.getFileDocumentId());
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private NotificationBotpressDTO notificationBotpress(TDocumentTransaction transactionFind, TDocumentTransaction.DocumentStatus documentStatus) {
        NotificationBotpressDTO notifyTemp = new NotificationBotpressDTO();
        notifyTemp.setConversationId(transactionFind.getConversationId());
        notifyTemp.setIdDocumentTransaction(transactionFind.getId());
        notifyTemp.setUuid(transactionFind.getUuid());
        notifyTemp.setMessage("Notify Broker");
        notifyTemp.setTypeNotify("BROKERS");
        notifyTemp.setDocumentStatus(documentStatus);
        return notifyTemp;
    }

    public NotifySignServiceImpl(BotpressApiClient botpressApiClient, EmailCustomService emailCustomService, DocumentTransactionDetailService documentTransactionDetailService, FileDocumentService fileDocumentService, InsuredPersonService insuredPersonService) {
        this.botpressApiClient = botpressApiClient;
        this.emailCustomService = emailCustomService;
        this.documentTransactionDetailService = documentTransactionDetailService;
        this.fileDocumentService = fileDocumentService;
        this.insuredPersonService = insuredPersonService;
    }
}

