/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.logic.dto.InclusiveInsuranceDTO;
import com.eabrokers.logic.entity.insurance.TInclusiveInsurance;
import com.eabrokers.logic.entity.insurance.TPrimaFrequency;
import com.eabrokers.logic.infrastructure.service.insurance.InclusiveInsuranceService;
import com.eabrokers.logic.infrastructure.service.insurance.LinkService;
import com.eabrokers.logic.infrastructure.service.insurance.PrimaFrequencyService;
import com.eabrokers.logic.repository.insurance.InclusiveInsuranceDAO;
import com.eabrokers.utils.ApiResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class InclusiveInsuranceServiceImpl
implements InclusiveInsuranceService {
    @Autowired
    private InclusiveInsuranceDAO inclusiveInsuranceDao;
    @Autowired
    private LinkService linkService;
    @Autowired
    private PrimaFrequencyService primaFrequencyService;

    public Optional<TInclusiveInsurance> findInclusiveInsuranceByPrimaId(Long primaId) {
        return this.inclusiveInsuranceDao.findInclusiveInsuranceByPrimaId(primaId);
    }

    public ResponseEntity<ApiResponse<?>> listInclusiveInsurance(String codeDocumentInsurance) {
        List<InclusiveInsuranceDTO> listData = this.inclusiveInsuranceDao.listInclusiveInsuranceByCode(codeDocumentInsurance).stream().map(insurance -> {
            InclusiveInsuranceDTO data = new InclusiveInsuranceDTO();
            data.setId(insurance.getId());
            data.setTitle(insurance.getTitle());
            data.setSubTitle(insurance.getSubTitle());
            data.setCodeInsurance(insurance.getCodeInsurance());
            data.setSubject(insurance.getSubject());
            data.setInformationAdditional(insurance.getInformationAdditional());
            data.setCodeDocumentInsurance(insurance.getCodeDocumentInsurance());
            data.setStatus(insurance.getStatus());
            data.setUrlImage(this.linkService.linkFilesAssets(insurance.getBannerFileId()));
            data.setPlanTypes(insurance.getPlanTypes());
            ArrayList primaTypes = new ArrayList();
            insurance.getPrimaTypes().forEach(prima -> {
                Optional primaFrequency = this.primaFrequencyService.findById(prima.getPrimaFrequency());
                InclusiveInsuranceDTO.PrimaTypeDTO primaTypesItem = new InclusiveInsuranceDTO.PrimaTypeDTO();
                primaTypesItem.setId(prima.getId());
                primaTypesItem.setPrimaFrequency(prima.getPrimaFrequency());
                primaTypesItem.setValue(prima.getValue());
                primaTypesItem.setDescription(primaFrequency.isPresent() ? ((TPrimaFrequency)primaFrequency.get()).getDescription() : "");
                primaTypes.add(primaTypesItem);
            });
            data.setPrimaTypes(primaTypes);
            return data;
        }).toList();
        return new ResponseEntity((Object)ApiResponse.ok(listData, (boolean)false), (HttpStatusCode)HttpStatus.OK);
    }
}

