/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.logic.dto.FileDTO;
import com.eabrokers.logic.entity.insurance.TFile;
import com.eabrokers.logic.infrastructure.service.insurance.FileService;
import com.eabrokers.logic.repository.insurance.FileDAO;
import com.eabrokers.utils.FileUtil;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class FileServiceImpl
implements FileService {
    @Autowired
    private FileDAO fileDao;

    public Optional<TFile> getFileById(String fileId) {
        return this.fileDao.findById((Object)fileId);
    }

    public TFile save(TFile file) {
        return (TFile)this.fileDao.save((Object)file);
    }

    public TFile saveFile(FileDTO dto) {
        String uuid = UUID.randomUUID().toString();
        byte[] dataByte = FileUtil.base64ToByte((String)dto.getBase64());
        String contentType = FileUtil.determineFileType((String)dto.getContentType());
        TFile fileSaved = new TFile();
        fileSaved.setId(uuid);
        fileSaved.setFile(dataByte);
        fileSaved.setFileName(dto.getFileName());
        fileSaved.setContentType(contentType);
        fileSaved.setFilePublic(dto.isFilePublic());
        return (TFile)this.fileDao.save((Object)fileSaved);
    }

    public ResponseEntity<byte[]> getByteFileById(String fileId) {
        Optional documentFile = this.getFileById(fileId);
        if (documentFile.isPresent()) {
            HttpHeaders headers = new HttpHeaders();
            String fileType = FileUtil.determineFileType((String)((TFile)documentFile.get()).getContentType());
            if (fileType == null) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            headers.setContentType(MediaType.parseMediaType((String)fileType));
            return new ResponseEntity((Object)((TFile)documentFile.get()).getFile(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    public ResponseEntity<?> updateFileById(FileDTO fileDTO) {
        HttpHeaders headers = new HttpHeaders();
        Optional fileFind = this.getFileById(fileDTO.getUuid());
        if (!fileFind.isPresent()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ((TFile)fileFind.get()).setFile(FileUtil.base64ToByte((String)fileDTO.getBase64()));
        TFile fileNew = this.save((TFile)fileFind.get());
        return new ResponseEntity((Object)fileNew.getId(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }
}

