/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.logic.data.DataFileDocumentSign;
import com.eabrokers.logic.dto.InsuredDocumentDTO;
import com.eabrokers.logic.entity.insurance.TBranch;
import com.eabrokers.logic.entity.insurance.TDocumentInsurance;
import com.eabrokers.logic.entity.insurance.TFileDocument;
import com.eabrokers.logic.entity.insurance.TFinancialInstitution;
import com.eabrokers.logic.entity.insurance.TInclusiveInsurance;
import com.eabrokers.logic.entity.insurance.TInsuranceCompany;
import com.eabrokers.logic.infrastructure.service.biometria.FirmaService;
import com.eabrokers.logic.infrastructure.service.insurance.FileDocumentService;
import com.eabrokers.logic.infrastructure.service.insurance.StampDocumentService;
import com.eabrokers.logic.repository.insurance.FileDocumentDAO;
import com.eabrokers.utils.FileUtil;
import com.eabrokers.utils.StampDocumentUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class FileDocumentServiceImpl
implements FileDocumentService {
    private final FileDocumentDAO fileDocumentDAO;
    private final FirmaService firmaService;
    private final StampDocumentService stampDocumentService;

    public TFileDocument save(TFileDocument fileDocument) {
        return (TFileDocument)this.fileDocumentDAO.save((Object)fileDocument);
    }

    public ResponseEntity<byte[]> getByteFileById(String fileId) {
        Optional documentFile = this.getFileById(fileId);
        if (documentFile.isPresent()) {
            HttpHeaders headers = new HttpHeaders();
            String fileType = FileUtil.determineFileType((String)((TFileDocument)documentFile.get()).getContentType());
            if (fileType == null) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            headers.setContentType(MediaType.parseMediaType((String)fileType));
            return new ResponseEntity((Object)((TFileDocument)documentFile.get()).getFile(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    public Optional<TFileDocument> getFileById(String fileId) {
        return this.fileDocumentDAO.findById((Object)fileId);
    }

    public String getDocumentFileId(InsuredDocumentDTO insuredDocumentDTO, TInclusiveInsurance dataInclusiveInsurance, double valuePlan, TFinancialInstitution dataFinancialInstitution, TInsuranceCompany dataInsuranceCompany, TBranch dataBranch, DataFileDocumentSign dataDocumentSign, byte[] fileDocument, Long frequencyId, TDocumentInsurance documentInsurance) {
        Map mapStamp = this.stampDocumentService.findDataMapByDocumentInsuranceId(documentInsurance.getId());
        List listStampData = StampDocumentUtil.stampDocument((InsuredDocumentDTO)insuredDocumentDTO, (TDocumentInsurance)documentInsurance, (TInclusiveInsurance)dataInclusiveInsurance, (TFinancialInstitution)dataFinancialInstitution, (TInsuranceCompany)dataInsuranceCompany, (TBranch)dataBranch, (double)valuePlan, (Long)frequencyId, (Map)mapStamp);
        byte[] base64Stamp = this.firmaService.stampInformationDocuments(fileDocument, listStampData);
        TFileDocument fileTemp = this.createFileDocument(base64Stamp);
        this.save(fileTemp);
        return fileTemp.getId();
    }

    private TFileDocument createFileDocument(byte[] base64StampedFile) {
        TFileDocument fileDocument = new TFileDocument();
        fileDocument.setId(UUID.randomUUID().toString());
        fileDocument.setFile(base64StampedFile);
        fileDocument.setContentType("application/pdf");
        fileDocument.setFilePublic(true);
        fileDocument.setFileStatus(TFileDocument.FileStatus.PENDING);
        return fileDocument;
    }

    public FileDocumentServiceImpl(FileDocumentDAO fileDocumentDAO, FirmaService firmaService, StampDocumentService stampDocumentService) {
        this.fileDocumentDAO = fileDocumentDAO;
        this.firmaService = firmaService;
        this.stampDocumentService = stampDocumentService;
    }
}

