/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.logic.client.EmailApiClient;
import com.eabrokers.logic.dto.InvoiceFakeDTO;
import com.eabrokers.logic.entity.insurance.TDocumentTransaction;
import com.eabrokers.logic.entity.insurance.TInsuredPerson;
import com.eabrokers.logic.infrastructure.service.insurance.EmailCustomService;
import com.eabrokers.logic.model.FileEmail;
import com.eabrokers.logic.request.EmailRequest;
import com.eabrokers.utils.EmailUtil;
import com.eabrokers.utils.PdfBillUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EmailCustomServiceImpl
implements EmailCustomService {
    private static final Logger log = LoggerFactory.getLogger(EmailCustomServiceImpl.class);
    @Value(value="${property.server.email_code_email}")
    private String adminEmailCodeEmail;
    @Autowired
    private EmailApiClient emailApiClient;

    public boolean sendEmailUser(TInsuredPerson person, List<FileEmail> listFileEmail, TDocumentTransaction.DocumentStatus documentStatus, InvoiceFakeDTO invoice) {
        String contentEmail = "";
        try {
            String fullName = person.getFullName();
            ArrayList<String> listEmail = new ArrayList<String>();
            listEmail.add(person.getEmail());
            if (TDocumentTransaction.DocumentStatus.SIGNED_INSURANCE == documentStatus) {
                contentEmail = EmailUtil.getInsuranceCompanySignedEmailContent((String)fullName.toUpperCase());
                if (invoice != null) {
                    String invoiceBase64 = PdfBillUtil.generateInvoiceEcuadorStyle((TInsuredPerson)person, (InvoiceFakeDTO)invoice);
                    FileEmail fileEmailInvoice = new FileEmail();
                    fileEmailInvoice.setFileName("Factura.pdf");
                    fileEmailInvoice.setFileBase64(invoiceBase64);
                    listFileEmail.add(fileEmailInvoice);
                }
            } else {
                contentEmail = EmailUtil.getUserSignedEmailContent((String)fullName.toUpperCase());
            }
            String subject = "Documentos Firmados";
            EmailRequest emailRequest = new EmailRequest();
            emailRequest.setDestinatarios(listEmail);
            emailRequest.setContentisHtml(true);
            emailRequest.setAsunto(subject);
            emailRequest.setContenido(contentEmail);
            emailRequest.setArchivos(listFileEmail);
            emailRequest.setCodigoEmail(this.adminEmailCodeEmail);
            return this.emailApiClient.sendEmail(emailRequest);
        }
        catch (Exception e) {
            log.info("Error send email" + String.valueOf(e));
            System.out.println(e);
            return false;
        }
    }
}

