/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.common.transactions.TransactionCustom;
import com.eabrokers.logic.dto.InsuredDocumentDTO;
import com.eabrokers.logic.dto.InvoiceFakeDTO;
import com.eabrokers.logic.dto.PreInsuredDocumentDTO;
import com.eabrokers.logic.entity.insurance.TDocumentTransaction;
import com.eabrokers.logic.entity.insurance.TInclusiveInsurance;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentTransactionService;
import com.eabrokers.logic.infrastructure.service.insurance.InclusiveInsuranceService;
import com.eabrokers.logic.infrastructure.service.insurance.NotifySignService;
import com.eabrokers.logic.infrastructure.service.insurance.PlanTypeService;
import com.eabrokers.logic.repository.insurance.DocumentTransactionAllViewDAO;
import com.eabrokers.logic.repository.insurance.DocumentTransactionDAO;
import com.eabrokers.logic.repository.insurance.DocumentTransactionViewDAO;
import jakarta.persistence.EntityNotFoundException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DocumentTransactionServiceImpl
implements DocumentTransactionService {
    private static final Logger log = LoggerFactory.getLogger(DocumentTransactionServiceImpl.class);
    private final DocumentTransactionDAO documentTransactionDAO;
    private final DocumentTransactionAllViewDAO documentTransactionViewDAO;
    private final DocumentTransactionViewDAO documentTransactionVDAO;
    private final NotifySignService notifySignService;
    private final InclusiveInsuranceService inclusiveInsuranceService;
    private final PlanTypeService planTypeService;

    public ResponseEntity<?> putDocumentsUpdateBill(Long documentTransactionId, String status) {
        try {
            TDocumentTransaction documentTransaction = (TDocumentTransaction)this.documentTransactionDAO.findById((Object)documentTransactionId).orElseThrow(() -> new EntityNotFoundException("No se encontr\u00f3 la transacci\u00f3n con ID: " + documentTransactionId));
            try {
                InvoiceFakeDTO invoice = this.getInvoiceDTO(documentTransaction.getPrimaType());
                this.notifySignService.notifyDocumentStatus(documentTransaction, TDocumentTransaction.DocumentStatus.SIGNED_INSURANCE, invoice);
            }
            catch (Exception e) {
                log.error("Error al notificar el estado del documento: {}", (Object)e.getMessage(), (Object)e);
            }
            documentTransaction.setDocumentStatus(TDocumentTransaction.DocumentStatus.BILLED);
            documentTransaction.setBillDate(LocalDateTime.now());
            this.documentTransactionDAO.save((Object)documentTransaction);
            return TransactionCustom.ok();
        }
        catch (EntityNotFoundException e) {
            log.warn("Documento no encontrado: {}", (Object)e.getMessage());
            return TransactionCustom.error();
        }
        catch (DataAccessException e) {
            log.error("Error de base de datos al actualizar documento: {}", (Object)e.getMessage(), (Object)e);
            return TransactionCustom.error();
        }
        catch (Exception e) {
            log.error("Error inesperado al actualizar documento: {}", (Object)e.getMessage(), (Object)e);
            return TransactionCustom.error();
        }
    }

    public ResponseEntity<?> getDocumentsByStatus(String status) {
        List data = this.documentTransactionVDAO.findByDocumentStatusOrderByCreatedAtDesc(status);
        return TransactionCustom.ok((Object)data);
    }

    public ResponseEntity<?> getDocumentsHistory(Pageable pageable, LocalDate startDate, LocalDate endDate, String status) {
        LocalDateTime start = startDate != null ? startDate.atStartOfDay() : LocalDateTime.MIN;
        LocalDateTime end = endDate != null ? endDate.atTime(23, 59, 59) : LocalDateTime.MAX;
        Page data = this.documentTransactionVDAO.findByDocumentStatusAndCreatedAtBetweenOrderByCreatedAtDesc(status, start, end, pageable);
        return TransactionCustom.ok((Object)data);
    }

    public ResponseEntity<?> findTransactions(Pageable pageable, LocalDate startDate, LocalDate endDate) {
        LocalDateTime start = startDate != null ? startDate.atStartOfDay() : LocalDateTime.MIN;
        LocalDateTime end = endDate != null ? endDate.atTime(23, 59, 59) : LocalDateTime.MAX;
        Page data = this.documentTransactionViewDAO.findByCreatedAtBetweenOrderByCreatedAtDesc(start, end, pageable);
        return TransactionCustom.ok((Object)data);
    }

    public ResponseEntity<?> getDocumentsByTransactionId(Long transactionId) {
        List listDocumentResultDTO = this.documentTransactionDAO.findDocumentsByTransactionId(transactionId);
        return TransactionCustom.ok((Object)listDocumentResultDTO);
    }

    public TDocumentTransaction save(TDocumentTransaction documentTransaction) {
        return (TDocumentTransaction)this.documentTransactionDAO.save((Object)documentTransaction);
    }

    public Optional<TDocumentTransaction> findById(Long documentTransactionId) {
        return this.documentTransactionDAO.findById((Object)documentTransactionId);
    }

    public TDocumentTransaction documentTransactionFindById(Long documentTransactionId) {
        Optional documentTransactionFind = this.findById(documentTransactionId);
        if (documentTransactionFind.isEmpty()) {
            return null;
        }
        TDocumentTransaction documentTransaction = (TDocumentTransaction)documentTransactionFind.get();
        documentTransaction.getDocumentTransactionDetail().size();
        return documentTransaction;
    }

    public TDocumentTransaction saveDocumentTransaction(InsuredDocumentDTO insuredDocumentDTO, Long financialAccountId, int totalDocuments, PreInsuredDocumentDTO preInsuredDocumentDTO) {
        TDocumentTransaction documentTransaction = new TDocumentTransaction();
        documentTransaction.setFinancialAccountId(financialAccountId);
        documentTransaction.setPrimaType(insuredDocumentDTO.getPrimaId());
        documentTransaction.setInsuranceNumber(Integer.valueOf(1));
        documentTransaction.setDocumentStatus(TDocumentTransaction.DocumentStatus.PENDING);
        documentTransaction.setTotalDocument(Integer.valueOf(totalDocuments));
        documentTransaction.setNotifyType(preInsuredDocumentDTO.getNotifyType());
        documentTransaction.setConversationId(preInsuredDocumentDTO.getConversationId());
        documentTransaction.setUuid(preInsuredDocumentDTO.getUuid());
        return this.save(documentTransaction);
    }

    public InvoiceFakeDTO getInvoiceDTO(Long primaId) {
        Optional inclusiveInsurance = this.inclusiveInsuranceService.findInclusiveInsuranceByPrimaId(primaId);
        if (inclusiveInsurance.isPresent()) {
            double value = this.planTypeService.calculatePlanValue(((TInclusiveInsurance)inclusiveInsurance.get()).getId());
            double valueWithoutTax = value / 1.15;
            double tax = value - valueWithoutTax;
            InvoiceFakeDTO invoice = new InvoiceFakeDTO();
            invoice.setTitle(((TInclusiveInsurance)inclusiveInsurance.get()).getSubTitle());
            invoice.setUnitValue(DocumentTransactionServiceImpl.roundToTwoDecimals((double)valueWithoutTax));
            invoice.setTaxValue(DocumentTransactionServiceImpl.roundToTwoDecimals((double)tax));
            invoice.setTotalValue(value);
            System.out.println(invoice);
            return invoice;
        }
        return null;
    }

    public static double roundToTwoDecimals(double valor) {
        return (double)Math.round(valor * 100.0) / 100.0;
    }

    public DocumentTransactionServiceImpl(DocumentTransactionDAO documentTransactionDAO, DocumentTransactionAllViewDAO documentTransactionViewDAO, DocumentTransactionViewDAO documentTransactionVDAO, NotifySignService notifySignService, InclusiveInsuranceService inclusiveInsuranceService, PlanTypeService planTypeService) {
        this.documentTransactionDAO = documentTransactionDAO;
        this.documentTransactionViewDAO = documentTransactionViewDAO;
        this.documentTransactionVDAO = documentTransactionVDAO;
        this.notifySignService = notifySignService;
        this.inclusiveInsuranceService = inclusiveInsuranceService;
        this.planTypeService = planTypeService;
    }
}

