/*
 * Decompiled with CFR 0.152.
 */
package com.eabrokers.logic.infrastructure.serviceImpl.insurance;

import com.eabrokers.logic.dto.DocumentInsuranceDTO;
import com.eabrokers.logic.entity.insurance.TDocumentInsurance;
import com.eabrokers.logic.infrastructure.service.insurance.DocumentInsuranceService;
import com.eabrokers.logic.infrastructure.service.insurance.LinkService;
import com.eabrokers.logic.repository.insurance.DocumentInsuranceDAO;
import com.eabrokers.logic.repository.insurance.DocumentInsuranceVIewDAO;
import com.eabrokers.utils.ApiResponse;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DocumentInsuranceServiceImpl
implements DocumentInsuranceService {
    private static final Logger log = LoggerFactory.getLogger(DocumentInsuranceServiceImpl.class);
    @Autowired
    private DocumentInsuranceDAO documentInsuranceDao;
    @Autowired
    private DocumentInsuranceVIewDAO documentInsuranceVIewDAO;
    @Autowired
    private LinkService linkService;

    public Optional<TDocumentInsurance> findById(Long id) {
        return this.documentInsuranceDao.findById((Object)id);
    }

    public ResponseEntity<?> saveDocumentInsurance(DocumentInsuranceDTO documentInsuranceDTO) {
        TDocumentInsurance dataCreate = new TDocumentInsurance();
        dataCreate.setTitle(documentInsuranceDTO.getTitle());
        dataCreate.setTypeDocument(documentInsuranceDTO.getTypeDocument().toUpperCase());
        TDocumentInsurance dataSave = (TDocumentInsurance)this.documentInsuranceDao.save((Object)dataCreate);
        return new ResponseEntity((Object)ApiResponse.ok((Object)dataSave, (boolean)false), (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<?> listDocumentInsurance() {
        List<DocumentInsuranceDTO> listData = this.documentInsuranceDao.findAll().stream().map(insurance -> {
            DocumentInsuranceDTO data = new DocumentInsuranceDTO();
            data.setTitle(insurance.getTitle());
            data.setTypeDocument(insurance.getTypeDocument());
            data.setNameFile(insurance.getNameFile());
            data.setVersionDocument(insurance.getVersionDocument());
            data.setUrlPDF(this.linkService.linkFilesAssets(insurance.getPdfFileId()));
            return data;
        }).toList();
        return new ResponseEntity((Object)ApiResponse.ok(listData, (boolean)false), (HttpStatusCode)HttpStatus.OK);
    }

    public List<TDocumentInsurance> findDocumentsByAuthorization(Boolean partnerActive, Long accountTypeId) {
        return this.documentInsuranceDao.findDocumentsByAuthorization(partnerActive, accountTypeId);
    }

    public List<TDocumentInsurance> findDocumentsByCertificate(Boolean partnerActive, Long primaFrequencyId, Boolean unemploymentActive) {
        return this.documentInsuranceDao.findDocumentsByCertificate(partnerActive, primaFrequencyId, unemploymentActive);
    }

    public ResponseEntity<?> findDocumentInsuranceView(String signStatus, String role, Pageable pageable) {
        log.info("Buscando documentos por estado y rol {} {} con paginaci\u00f3n {}", new Object[]{signStatus, role, pageable});
        Page infoDocInsurance = this.documentInsuranceVIewDAO.findByStatusAndRole(signStatus, role, pageable);
        return new ResponseEntity((Object)ApiResponse.ok((Object)infoDocInsurance, (boolean)false), (HttpStatusCode)HttpStatus.OK);
    }
}

